/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.cmis;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.query.cmis.LoadCMISData;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.junit.Before;
import org.junit.Test;

public class SortCMISTest
extends LoadCMISData {
    @Before
    public void setup() throws Exception {
        SortCMISTest.addTypeTestData(testCMISFolder00NodeRef, testCMISRootNodeRef, testCMISBaseFolderNodeRef, testCMISBaseFolderQName, testCMISFolder00QName, testCMISDate00);
        this.addTypeSortTestData(testCMISFolder00NodeRef, testCMISRootNodeRef, testCMISBaseFolderNodeRef, testCMISBaseFolderQName, testCMISFolder00QName, testCMISDate00);
    }

    @Override
    protected void addTypeSortTestData(NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1) throws IOException {
        this.addSortableNull(folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "start", 0);
        for (int i = 0; i < 10; ++i) {
            this.addSortableNode(folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, i);
            if (i != 5) continue;
            this.addSortableNull(folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "mid", 1);
        }
        this.addSortableNull(folder00NodeRef, rootNodeRef, baseFolderNodeRef, baseFolderQName, folder00QName, date1, "end", 2);
    }

    private void addSortableNull(NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, Object baseFolderQName, Object folder00QName, Date date1, String id, int offset) throws IOException {
        HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc00 = new MLTextPropertyValue();
        desc00.addValue(Locale.ENGLISH, "Test null");
        content00Properties.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)desc00);
        content00Properties.put(ContentModel.PROP_TITLE, (PropertyValue)desc00);
        content00Properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue("Test null"));
        content00Properties.put(ContentModel.PROP_CREATED, (PropertyValue)new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date1)));
        NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
        QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Test null");
        ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(SortCMISTest.getCore(), dataModel, 1, 200 + offset, 1, extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, null, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
    }

    @Test
    public void checkOrder() throws Exception {
        SimpleOrderedMap report = new SimpleOrderedMap();
        Integer[] asc = new Integer[]{200, 201, 202, 1008, 1005, 1004, 1009, 1001, 1007, 1006, 1003, 1002, 100, 1000};
        Integer[] desc = new Integer[]{1000, 100, 1002, 1003, 1006, 1007, 1001, 1009, 1004, 1005, 1008, 202, 201, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleTextUntokenised", asc, desc);
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleTextBoth", asc, desc);
        asc = new Integer[]{200, 201, 202, 1009, 100, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008};
        desc = new Integer[]{1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 1000, 100, 1009, 202, 201, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleMLTextUntokenised", asc, desc);
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleMLTextBoth", asc, desc);
        asc = new Integer[]{200, 1000, 201, 202, 100, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new Integer[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 100, 202, 201, 1000, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleFloat", asc, desc);
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleDouble", asc, desc);
        asc = new Integer[]{200, 1000, 201, 202, 100, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new Integer[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 100, 202, 201, 1000, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleInteger", asc, desc);
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleLong", asc, desc);
        asc = new Integer[]{200, 201, 202, 100, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009};
        desc = new Integer[]{1009, 1008, 1007, 1006, 1005, 1004, 1003, 1002, 1001, 1000, 100, 202, 201, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleDate", asc, desc);
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleDatetime", asc, desc);
        asc = new Integer[]{1001, 1003, 1005, 1007, 1009, 100, 1000, 1002, 1004, 1006, 1008, 200, 201, 202};
        desc = new Integer[]{1008, 1006, 1004, 1002, 1000, 100, 1009, 1007, 1005, 1003, 1001, 202, 201, 200};
        this.checkOrderableProperty((NamedList<Object>)report, "cmistest:singleBoolean", asc, desc);
    }

    private void checkOrderableProperty(NamedList<Object> report, String propertyQueryName, Integer[] asc, Integer[] desc) throws Exception {
        String queryASC = String.format("SELECT %1$s FROM cmistest:extendedContent ORDER BY %1$s ASC, cmis:objectId ASC", propertyQueryName);
        SortCMISTest.assertQueryCollection(queryASC, asc);
        String queryDesc = String.format("SELECT %1$s FROM cmistest:extendedContent ORDER BY %1$s DESC, cmis:objectId DESC", propertyQueryName);
        SortCMISTest.assertQueryCollection(queryDesc, desc);
    }
}

