/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.cmis;

import org.alfresco.repo.search.adaptor.QueryConstants;
import org.alfresco.solr.query.cmis.LoadCMISData;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Ignore;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
@SolrTestCaseJ4.SuppressSSL
public class AlfrescoCMISQParserPluginIT
extends LoadCMISData
implements QueryConstants {
    @Test
    public void cmisBasic() throws Exception {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * from cmis:folder"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * from cmis:document"), this.expectedDocCount(11));
    }

    @Test
    public void testCMISParentID() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId =  '" + String.valueOf(testCMISBaseFolderNodeRef) + "'"), this.expectedDocCount(4));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId <> '" + String.valueOf(testCMISBaseFolderNodeRef) + "'"), this.expectedDocCount(7));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IN     ('" + String.valueOf(testCMISBaseFolderNodeRef) + "')"), this.expectedDocCount(4));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId NOT IN ('" + String.valueOf(testCMISBaseFolderNodeRef) + "')"), this.expectedDocCount(7));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisContentStreamFileName() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'AA%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'BB_'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'CC\\\\'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'DD\\''"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'EE.aa'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'FF.EE'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'GG*GG'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'HH?HH'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'aa'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <> 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <  'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <= 'Alfresco Tutorial'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >  'Alfresco Tutorial'"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >= 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IN     ('Alfresco Tutorial')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT IN ('Alfresco Tutorial')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName     LIKE 'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT LIKE 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisContentStreamMimeType() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType =  'text/plain'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <> 'text/plain'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <  'text/plain'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <= 'text/plain'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >  'text/plain'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >= 'text/plain'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IN     ('text/plain')"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT IN ('text/plain')"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType     LIKE 'text/plain'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT LIKE 'text/plain'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisContentStreamLength() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength =  750"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <> 750"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <  750"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <= 750"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >  750"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >= 750"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IN     (750)"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT IN (750)"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength     LIKE '750'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT LIKE '750'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS NULL"), this.expectedDocCount(0));
    }

    public void checkCmisName() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name =  'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name <> 'Folder 1'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name <  'Folder 1'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name <= 'Folder 1'"), this.expectedDocCount(3));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name >  'Folder 1'"), this.expectedDocCount(8));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name >= 'Folder 1'"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name IN     ('Folder 1')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT IN ('Folder 1')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name     LIKE 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT LIKE 'Folder 1'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:folder WHERE cmis:name IS     NULL"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name =  'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name <> 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name <  'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name <= 'Alfresco Tutorial'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name >  'Alfresco Tutorial'"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name >= 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name IN     ('Alfresco Tutorial')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name NOT IN ('Alfresco Tutorial')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name NOT LIKE 'Alfresco Tutorial'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisCreatedBy() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy =  'System'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <> 'System'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <  'System'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <= 'System'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >  'System'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >= 'System'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IN ('System')"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT IN ('System')"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy LIKE 'System'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT LIKE 'System'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisObjectTypeId() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId =  'cmis:document'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId <> 'cmis:document'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IN     ('cmis:document')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId NOT IN ('cmis:document')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS  NULL"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId =  'cmis:folder'"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <> 'cmis:folder'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IN     ('cmis:folder')"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT IN ('cmis:folder')"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisObjecId() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId =  '" + String.valueOf(testCMISFolder00NodeRef) + "'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <> '" + String.valueOf(testCMISFolder00NodeRef) + "'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IN     ('" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId  NOT IN('" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE IN_FOLDER('" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE IN_TREE  ('" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(6));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS     NULL"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId =  '" + String.valueOf(testCMISFolder00NodeRef) + ";1.0'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <> '" + String.valueOf(testCMISFolder00NodeRef) + ";1.0'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IN     ('" + String.valueOf(testCMISFolder00NodeRef) + ";1.0')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId  NOT IN('" + String.valueOf(testCMISFolder00NodeRef) + ";1.0')"), this.expectedDocCount(10));
        Object id = testCMISContent00NodeRef.toString();
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId =  '" + (String)id + "'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId <> '" + (String)id + "'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IN     ('" + (String)id + "')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId  NOT IN('" + (String)id + "')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS     NULL"), this.expectedDocCount(0));
        id = String.valueOf(testCMISContent00NodeRef) + ";1.0";
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId =  '" + (String)id + "'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId <> '" + (String)id + "'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IN     ('" + (String)id + "')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId  NOT IN('" + (String)id + "')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:objectId FROM cmis:document WHERE cmis:objectId IS     NULL"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisTextPredicates() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9\\''"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name = 'Folder 1'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND 'Folder 1' = ANY cmis:name"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name <> 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <> 'Folder 1'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <  'Folder 1'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <= 'Folder 1'"), this.expectedDocCount(3));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name >  'Folder 1'"), this.expectedDocCount(8));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name >= 'Folder 1'"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name IN ('Folder 1', '1')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT IN ('Folder 1', 'Folder 9\\'')"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name IN ('Folder 1', 'Folder 9\\'')"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name NOT IN ('2', '3')"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Fol%'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ 1'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ %'"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ %'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ _'"), this.expectedDocCount(9));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ _'"), this.expectedDocCount(2));
    }

    @Test
    public void checkCmisSimpleConjunction() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder'"), this.expectedDocCount(0));
    }

    @Test
    public void checkCmisSimpleDisjunction() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 2'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1' OR cmis:name = 'Folder 2'"), this.expectedDocCount(2));
    }

    @Test
    public void checkCmisExists() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE cmis:name IS NULL"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE cmis:name IS NOT NULL"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE cmis:name IS NULL"), this.expectedDocCount(0));
    }

    @Test
    @Ignore(value="https://issues.alfresco.com/jira/browse/SEARCH-2527")
    public void checkInTree() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE IN_TREE('" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(6));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder F WHERE IN_TREE(F, '" + String.valueOf(testCMISFolder00NodeRef) + "')"), this.expectedDocCount(6));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_TREE(D, '" + String.valueOf(testCMISBaseFolderNodeRef) + "')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE IN_TREE('woof://woof/woof')"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:folder WHERE IN_TREE('woof://woof/woof;woof')"), this.expectedDocCount(0));
    }

    @Test
    public void checkLikeEscaping() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutoria_'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T_______'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T______\\_'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T\\%'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'GG*GG'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__*__'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%*%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'HH?HH'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__?__'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%?%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA\\%'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A%'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'a%'"), this.expectedDocCount(2));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A\\%'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB_'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB\\_'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B__'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B_\\_'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B\\_\\_'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'CC\\\\'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'DD\\''"), this.expectedDocCount(1));
    }

    @Test
    @Ignore(value="https://issues.alfresco.com/jira/browse/SEARCH-2527")
    public void checkDateFormatting() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-12-12T12:12:12.012Z'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-012-12T12:12:12.012Z'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-2-12T12:12:12.012Z'"), this.expectedDocCount(0));
    }

    @Test
    @Ignore(value="https://issues.alfresco.com/jira/browse/SEARCH-2527")
    public void checkAspectJoin() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId  ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:ownable"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:ownable where cm:owner = 'andy'"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cm:ownable where cm:owner = 'bob'"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cmis:document AS D LEFT OUTER JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cmis:folder AS D LEFT OUTER JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cmis:folder AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.*, T.* FROM cmis:document AS D JOIN cm:ownable AS O ON D.cmis:objectId = O.cmis:objectId JOIN cm:titled AS T ON T.cmis:objectId = D.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cm:ownable O JOIN cmis:document D ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, O.* FROM cm:ownable O LEFT  JOIN cmis:document D ON D.cmis:objectId = O.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, F.* FROM cmis:folder F JOIN cmis:document D ON D.cmis:objectId = F.cmis:objectId"), this.expectedDocCount(0));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT D.*, F.* FROM cmis:folder F LEFT JOIN cmis:document D ON D.cmis:objectId = F.cmis:objectId"), this.expectedDocCount(11));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT O.*, T.* FROM cm:ownable O JOIN cm:titled T ON O.cmis:objectId = T.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT O.*, T.* FROM cm:ownable O LEFT JOIN cm:titled T ON O.cmis:objectId = T.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("sElEcT o.*, T.* fRoM cm:ownable o JoIn cm:titled T oN o.cmis:objectId = T.cmis:objectId"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId )"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId  JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId  )"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN cmis:document AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, 'jumped') and D.cmis:contentStreamLength <> 2"), this.expectedDocCount(1));
    }

    @Test
    public void checkFTS() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT SCORE()as ONE, SCORE()as TWO, D.* FROM cmis:document D WHERE CONTAINS('\\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('\\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document D WHERE CONTAINS(D, 'cmis:name:\\'Tutorial\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT cmis:name as BOO FROM cmis:document D WHERE CONTAINS('BOO:\\'Tutorial\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document D WHERE CONTAINS('TEXT:\\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document D WHERE CONTAINS('d:content:\\'zebra\\'')"), this.expectedDocCount(10));
    }

    @Test
    public void checkFTSConnectives() {
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\' OR \\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\' or \\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\' \\'zebra\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\' and \\'zebra\\'')"), this.expectedDocCount(1));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\' or \\'zebra\\'')"), this.expectedDocCount(10));
        AlfrescoCMISQParserPluginIT.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmis:document where contains('\\'two\\'  \\'zebra\\'')"), this.expectedDocCount(1));
    }
}

