/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.afts.requestHandler;

import java.util.HashMap;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.dataload.TestDataProvider;
import org.alfresco.solr.query.afts.requestHandler.AbstractRequestHandlerIT;
import org.apache.solr.SolrTestCaseJ4;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AFTSDisjunctionIT
extends AbstractRequestHandlerIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        TestDataProvider dataProvider = new TestDataProvider(h);
        String[] names = new String[]{"test1", "test2", "test3"};
        TEST_ROOT_NODEREF = dataProvider.getRootNode();
        IntStream.range(0, names.length).forEach(index -> {
            String name = names[index];
            int dbId = index + 2;
            HashMap<QName, PropertyValue> properties = new HashMap<QName, PropertyValue>();
            properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue(name));
            AlfrescoSolrUtils.addNode(AFTSDisjunctionIT.getCore(), dataModel, 1, dbId, 1, ContentModel.TYPE_CONTENT, null, properties, null, "the_owner_of_this_node_is" + name, null, new NodeRef[]{TEST_ROOT_NODEREF}, new String[]{"/" + String.valueOf(dataProvider.qName("a_qname_for_node_" + name))}, dataProvider.newNodeRef(), true);
        });
    }

    @Test
    public void testDisjunction() {
        this.assertResponseCardinality("*", 4);
        this.assertResponseCardinality("cm:name:test*", 3);
        this.assertResponseCardinality("cm:name:test* AND NOT id:1", 3);
        this.assertResponseCardinality("cm:name:test* AND NOT (id:1)", 3);
        this.assertResponseCardinality("cm:name:test* AND (NOT id:1)", 3);
    }
}

