/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.basics;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResponsesComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int flags;
    protected Map<String, Integer> handle = new HashMap<String, Integer>();
    public static int ORDERED = 1;
    public static int SKIP = 2;
    public static int SKIPVAL = 4;
    public static int UNORDERED = 8;
    public static int FUZZY = 16;
    private static final double DOUBLE_RATIO_LIMIT = 1.0E-8;

    public void putHandleDefaults() {
        this.handle.put("[explain]", SKIPVAL);
        this.handle.put("timestamp", SKIPVAL);
        this.handle.put("score", SKIPVAL);
        this.handle.put("wt", SKIP);
        this.handle.put("distrib", SKIP);
        this.handle.put("shards.qt", SKIP);
        this.handle.put("shards", SKIP);
        this.handle.put("q", SKIP);
        this.handle.put("maxScore", SKIPVAL);
        this.handle.put("_version_", SKIP);
        this.handle.put("_original_parameters_", SKIP);
        this.handle.put("spellcheck-extras", SKIP);
        this.handle.put("FIELDS", UNORDERED);
    }

    public void compareSolrResponses(SolrResponse a, SolrResponse b) {
        this.handle.put("QTime", SKIPVAL);
        String cmp = SolrResponsesComparator.compare(a.getResponse(), b.getResponse(), this.flags, this.handle);
        if (cmp != null) {
            LOGGER.error("Mismatched responses:\n" + String.valueOf(a) + "\n" + String.valueOf(b));
            Assert.fail((String)cmp);
        }
    }

    public void validateResponse(QueryResponse response) {
        switch (response.getStatus()) {
            case 500: {
                throw new RuntimeException("Solr instance internal server error 500");
            }
        }
    }

    public void compareResponses(QueryResponse a, QueryResponse b) {
        this.compareSolrResponses((SolrResponse)a, (SolrResponse)b);
    }

    public static String compare(NamedList a, NamedList b, int flags, Map<String, Integer> handle) {
        boolean ordered;
        boolean bl = ordered = (flags & UNORDERED) == 0;
        if (!ordered) {
            HashMap<String, Object> mapA = new HashMap<String, Object>(a.size());
            for (int i = 0; i < a.size(); ++i) {
                Object object = mapA.put(a.getName(i), a.getVal(i));
            }
            HashMap<String, Object> mapB = new HashMap<String, Object>(b.size());
            for (int i = 0; i < b.size(); ++i) {
                Object object = mapB.put(b.getName(i), b.getVal(i));
            }
            return SolrResponsesComparator.compare(mapA, mapB, flags, handle);
        }
        int posa = 0;
        int posb = 0;
        int aSkipped = 0;
        int bSkipped = 0;
        while (posa < a.size() || posb < b.size()) {
            String cmp;
            String namea = null;
            String nameb = null;
            Object vala = null;
            Object valb = null;
            int flagsa = 0;
            int flagsb = 0;
            while (posa < a.size()) {
                namea = a.getName(posa);
                vala = a.getVal(posa);
                ++posa;
                flagsa = SolrResponsesComparator.flags(handle, namea);
                if ((flagsa & SKIP) == 0) break;
                namea = null;
                vala = null;
                ++aSkipped;
            }
            while (posb < b.size()) {
                nameb = b.getName(posb);
                valb = b.getVal(posb);
                ++posb;
                flagsb = SolrResponsesComparator.flags(handle, nameb);
                if ((flagsb & SKIP) != 0) {
                    nameb = null;
                    valb = null;
                    ++bSkipped;
                    continue;
                }
                if (SolrResponsesComparator.eq(namea, nameb)) break;
                return "." + namea + "!=" + nameb + " (unordered or missing)";
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = SolrResponsesComparator.compare(vala, valb, flagsa, handle)) == null) continue;
            return "." + namea + cmp;
        }
        if (a.size() - aSkipped != b.size() - bSkipped) {
            return ".size()==" + a.size() + "," + b.size() + " skipped=" + aSkipped + "," + bSkipped;
        }
        return null;
    }

    public static String compare1(Map a, Map b, int flags, Map<String, Integer> handle) {
        for (Object keya : a.keySet()) {
            Object valb;
            String cmp;
            Object vala = a.get(keya);
            int flagsa = SolrResponsesComparator.flags(handle, keya);
            if ((flagsa & SKIP) != 0) continue;
            if (!b.containsKey(keya)) {
                return "[" + String.valueOf(keya) + "]==null";
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = SolrResponsesComparator.compare(vala, valb = b.get(keya), flagsa, handle)) == null) continue;
            return "[" + String.valueOf(keya) + "]" + cmp;
        }
        return null;
    }

    public static String compare(Map a, Map b, int flags, Map<String, Integer> handle) {
        String cmp = SolrResponsesComparator.compare1(a, b, flags, handle);
        if (cmp != null) {
            return cmp;
        }
        return SolrResponsesComparator.compare1(b, a, flags, handle);
    }

    public static String compare(Set a, Set b, int flags, Map<String, Integer> handle) {
        String cmp = SolrResponsesComparator.compare1(a, b, flags, handle);
        if (cmp != null) {
            return cmp;
        }
        return SolrResponsesComparator.compare1(b, a, flags, handle);
    }

    private static String compare1(Set a, Set b, int flags, Map<String, Integer> handle) {
        for (Object valA : a) {
            int flagsa = SolrResponsesComparator.flags(handle, valA);
            if ((flagsa & SKIP) != 0 || b.contains(valA)) continue;
            return "[" + String.valueOf(valA) + "]==null";
        }
        return null;
    }

    public static String compare(SolrDocument a, SolrDocument b, int flags, Map<String, Integer> handle) {
        return SolrResponsesComparator.compare(a.getFieldValuesMap(), b.getFieldValuesMap(), flags, handle);
    }

    public static String compare(SolrDocumentList a, SolrDocumentList b, int flags, Map<String, Integer> handle) {
        String cmp;
        boolean ordered = (flags & UNORDERED) == 0;
        int f = SolrResponsesComparator.flags(handle, "maxScore");
        if (f == 0) {
            cmp = SolrResponsesComparator.compare(a.getMaxScore(), b.getMaxScore(), 0, handle);
            if (cmp != null) {
                return ".maxScore" + cmp;
            }
        } else if ((f & SKIP) == 0) {
            assert ((f & SKIPVAL) != 0);
            if (b.getMaxScore() != null && a.getMaxScore() == null) {
                return ".maxScore missing";
            }
        }
        if ((cmp = SolrResponsesComparator.compare(a.getNumFound(), b.getNumFound(), 0, handle)) != null) {
            return ".numFound" + cmp;
        }
        cmp = SolrResponsesComparator.compare(a.getStart(), b.getStart(), 0, handle);
        if (cmp != null) {
            return ".start" + cmp;
        }
        cmp = SolrResponsesComparator.compare(a.size(), b.size(), 0, handle);
        if (cmp != null) {
            return ".size()" + cmp;
        }
        if (ordered) {
            for (int i = 0; i < a.size(); ++i) {
                cmp = SolrResponsesComparator.compare((SolrDocument)a.get(i), (SolrDocument)b.get(i), 0, handle);
                if (cmp == null) continue;
                return "[" + i + "]" + cmp;
            }
            return null;
        }
        for (int i = 0; i < a.size(); ++i) {
            SolrDocument doc = (SolrDocument)a.get(i);
            Object key = doc.getFirstValue("id");
            SolrDocument docb = null;
            if (key == null) {
                docb = (SolrDocument)b.get(i);
            } else {
                for (int j = 0; j < b.size() && !key.equals((docb = (SolrDocument)b.get(j)).getFirstValue("id")); ++j) {
                }
            }
            cmp = SolrResponsesComparator.compare(doc, docb, 0, handle);
            if (cmp == null) continue;
            return "[id=" + String.valueOf(key) + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object[] a, Object[] b, int flags, Map<String, Integer> handle) {
        boolean ordered;
        boolean bl = ordered = (flags & UNORDERED) == 0;
        if (a.length != b.length) {
            return ".length:" + a.length + "!=" + b.length;
        }
        if (!ordered) {
            HashSet setA = Sets.newHashSet((Object[])a);
            HashSet setB = Sets.newHashSet((Object[])b);
            return SolrResponsesComparator.compare(setA, setB, flags, handle);
        }
        for (int i = 0; i < a.length; ++i) {
            String cmp = SolrResponsesComparator.compare(a[i], b[i], flags, handle);
            if (cmp == null) continue;
            return "[" + i + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object a, Object b, int flags, Map<String, Integer> handle) {
        if (a == b) {
            return null;
        }
        if (a == null || b == null) {
            return ":" + String.valueOf(a) + "!=" + String.valueOf(b);
        }
        if (a instanceof NamedList && b instanceof NamedList) {
            return SolrResponsesComparator.compare((NamedList)a, (NamedList)b, flags, handle);
        }
        if (a instanceof SolrDocumentList && b instanceof SolrDocumentList) {
            return SolrResponsesComparator.compare((SolrDocumentList)a, (SolrDocumentList)b, flags, handle);
        }
        if (a instanceof SolrDocument && b instanceof SolrDocument) {
            return SolrResponsesComparator.compare((SolrDocument)a, (SolrDocument)b, flags, handle);
        }
        if (a instanceof Map && b instanceof Map) {
            return SolrResponsesComparator.compare((Map)a, (Map)b, flags, handle);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return SolrResponsesComparator.compare((Object[])a, (Object[])b, flags, handle);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            if (!Arrays.equals((byte[])a, (byte[])b)) {
                return ":" + String.valueOf(a) + "!=" + String.valueOf(b);
            }
            return null;
        }
        if (a instanceof List && b instanceof List) {
            return SolrResponsesComparator.compare(((List)a).toArray(), ((List)b).toArray(), flags, handle);
        }
        if ((flags & FUZZY) != 0 && a instanceof Double && b instanceof Double) {
            double bbb;
            double aaa = (Double)a;
            if (aaa == (bbb = ((Double)b).doubleValue()) || ((Double)a).isNaN() && ((Double)b).isNaN()) {
                return null;
            }
            if (aaa == 0.0 || bbb == 0.0) {
                return ":" + String.valueOf(a) + "!=" + String.valueOf(b);
            }
            double diff = Math.abs(aaa - bbb);
            double ratio = Math.max(Math.abs(diff / aaa), Math.abs(diff / bbb));
            if (ratio > 1.0E-8) {
                return ":" + String.valueOf(a) + "!=" + String.valueOf(b);
            }
            return null;
        }
        if (!a.equals(b)) {
            return ":" + String.valueOf(a) + "!=" + String.valueOf(b);
        }
        return null;
    }

    public static boolean eq(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    public static int flags(Map<String, Integer> handle, Object key) {
        if (handle == null) {
            return 0;
        }
        Integer f = handle.get(key);
        return f == null ? 0 : f;
    }
}

