/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.minhash;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.minhash.MinHashFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class ContextAccumulatingFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private static Map<String, Set<MinHashFilter.LongPair>> contexts = new ConcurrentHashMap<String, Set<MinHashFilter.LongPair>>(128);

    protected ContextAccumulatingFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        boolean incremented = this.input.incrementToken();
        if (incremented) {
            String current = new String(this.termAttribute.buffer(), 0, this.termAttribute.length());
            String[] parts = current.split(" ");
            StringBuilder contextBuilder = new StringBuilder();
            StringBuilder wordBuilder = new StringBuilder();
            int l = parts.length;
            for (int i = 0; i < l; ++i) {
                if ((long)i == Math.round(Math.floor((double)(l - 1) / 2.0)) || (long)i == Math.round(Math.ceil((double)(l - 1) / 2.0))) {
                    if (wordBuilder.length() > 0) {
                        wordBuilder.append(" ");
                    }
                    wordBuilder.append(parts[i]);
                    continue;
                }
                if (contextBuilder.length() > 0) {
                    contextBuilder.append(" ");
                }
                contextBuilder.append(parts[i]);
            }
            String word = wordBuilder.toString();
            String context = contextBuilder.toString();
            Set<MinHashFilter.LongPair> wordContexts = contexts.get(word);
            if (wordContexts == null) {
                wordContexts = ConcurrentHashMap.newKeySet(128);
                contexts.put(word, wordContexts);
            }
            byte[] bytes = context.getBytes("UTF-16LE");
            MinHashFilter.LongPair contextHash = new MinHashFilter.LongPair();
            MinHashFilter.murmurhash3_x64_128((byte[])bytes, (int)0, (int)bytes.length, (int)0, (MinHashFilter.LongPair)contextHash);
            wordContexts.add(contextHash);
        }
        return incremented;
    }

    public void end() throws IOException {
        super.end();
        long count = 0L;
        for (Set<MinHashFilter.LongPair> thing : contexts.values()) {
            count += (long)thing.size();
        }
        System.out.println("Words = " + contexts.size() + "     contexts = " + count);
    }
}

