/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.transformer;

import java.io.IOException;
import java.util.ArrayList;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocValueDocTransformer
extends DocTransformer {
    protected static final Logger log = LoggerFactory.getLogger(DocValueDocTransformer.class);

    public String getName() {
        return "Alfresco doc value document transformer";
    }

    public void setContext(ResultContext context) {
        this.context = context;
    }

    public void transform(SolrDocument doc, int docid, float score) throws IOException {
        for (String fieldName : this.context.getSearcher().getFieldNames()) {
            SortedNumericDocValues sortedNumericDocValues;
            BinaryDocValues binaryDocValues;
            String alfrescoFieldName;
            SortedSetDocValues sortedSetDocValues;
            int ordinal;
            SchemaField schemaField = this.context.getSearcher().getSchema().getFieldOrNull(fieldName);
            if (schemaField == null || !schemaField.hasDocValues()) continue;
            SortedDocValues sortedDocValues = this.context.getSearcher().getSlowAtomicReader().getSortedDocValues(fieldName);
            if (sortedDocValues != null && (ordinal = sortedDocValues.getOrd(docid)) > -1) {
                doc.removeFields(fieldName);
                String alfrescoFieldName2 = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
                doc.removeFields(alfrescoFieldName2);
                doc.addField(alfrescoFieldName2, schemaField.getType().toObject(schemaField, sortedDocValues.lookupOrd(ordinal)));
            }
            if ((sortedSetDocValues = this.context.getSearcher().getSlowAtomicReader().getSortedSetDocValues(fieldName)) != null) {
                long ordinal2;
                ArrayList<Object> newValues = new ArrayList<Object>();
                sortedSetDocValues.setDocument(docid);
                while ((ordinal2 = sortedSetDocValues.nextOrd()) != -1L) {
                    newValues.add(schemaField.getType().toObject(schemaField, sortedSetDocValues.lookupOrd(ordinal2)));
                }
                doc.removeFields(fieldName);
                alfrescoFieldName = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
                doc.removeFields(alfrescoFieldName);
                doc.addField(alfrescoFieldName, newValues);
            }
            if ((binaryDocValues = this.context.getSearcher().getSlowAtomicReader().getBinaryDocValues(fieldName)) != null) {
                doc.removeFields(fieldName);
                String alfrescoFieldName3 = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
                doc.removeFields(alfrescoFieldName3);
                doc.addField(alfrescoFieldName3, schemaField.getType().toObject(schemaField, binaryDocValues.get(docid)));
            }
            if (schemaField.getType().getNumericType() == null) continue;
            NumericDocValues numericDocValues = this.context.getSearcher().getSlowAtomicReader().getNumericDocValues(fieldName);
            if (numericDocValues != null) {
                doc.removeFields(fieldName);
                String alfrescoFieldName4 = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
                doc.removeFields(alfrescoFieldName4);
                switch (schemaField.getType().getNumericType()) {
                    case DOUBLE: {
                        doc.addField(alfrescoFieldName4, (Object)Double.longBitsToDouble(numericDocValues.get(docid)));
                        break;
                    }
                    case FLOAT: {
                        doc.addField(alfrescoFieldName4, (Object)Float.valueOf(Float.intBitsToFloat((int)numericDocValues.get(docid))));
                        break;
                    }
                    case INT: {
                        doc.addField(alfrescoFieldName4, (Object)((int)numericDocValues.get(docid)));
                        break;
                    }
                    case LONG: {
                        doc.addField(alfrescoFieldName4, (Object)numericDocValues.get(docid));
                    }
                }
            }
            if ((sortedNumericDocValues = this.context.getSearcher().getSlowAtomicReader().getSortedNumericDocValues(fieldName)) == null) continue;
            sortedNumericDocValues.setDocument(docid);
            doc.removeFields(fieldName);
            alfrescoFieldName = AlfrescoSolrDataModel.getInstance().getAlfrescoPropertyFromSchemaField(fieldName);
            doc.removeFields(alfrescoFieldName);
            ArrayList<Number> newValues = new ArrayList<Number>(sortedNumericDocValues.count());
            if (sortedNumericDocValues.count() > 0) {
                block14: for (int i = 0; i < sortedNumericDocValues.count(); ++i) {
                    switch (schemaField.getType().getNumericType()) {
                        case DOUBLE: {
                            newValues.add(NumericUtils.sortableLongToDouble((long)sortedNumericDocValues.valueAt(i)));
                            continue block14;
                        }
                        case FLOAT: {
                            newValues.add(Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)sortedNumericDocValues.valueAt(i)))));
                            continue block14;
                        }
                        case INT: {
                            newValues.add((int)sortedNumericDocValues.valueAt(i));
                            continue block14;
                        }
                        case LONG: {
                            newValues.add(sortedNumericDocValues.valueAt(i));
                        }
                    }
                }
            }
            doc.addField(alfrescoFieldName, newValues);
        }
    }
}

