/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.solr.query.AbstractAuthorityQuery;
import org.alfresco.solr.query.BitsFilter;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrOwnerQuery
extends AbstractAuthorityQuery {
    public SolrOwnerQuery(String authority) {
        super(authority);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        BitsFilter ownerFilter = this.getOwnerFilter(this.authority, (SolrIndexSearcher)searcher);
        return new ConstantScoreQuery((Query)ownerFilter).createWeight(searcher, false);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OWNER").append(':');
        stringBuilder.append(this.authority);
        return stringBuilder.toString();
    }

    private BitsFilter getOwnerFilter(String owner, SolrIndexSearcher searcher) throws IOException {
        TermQuery query = new TermQuery(new Term("OWNER", owner));
        BitsFilterCollector collector = new BitsFilterCollector(searcher.getTopReaderContext().leaves().size());
        searcher.search((Query)query, (Collector)collector);
        return collector.getBitsFilter();
    }

    class BitsFilterCollector
    implements Collector,
    LeafCollector {
        private List<FixedBitSet> sets;
        private FixedBitSet set;

        public BitsFilterCollector(int leafCount) {
            this.sets = new ArrayList<FixedBitSet>(leafCount);
        }

        public BitsFilter getBitsFilter() {
            return new BitsFilter(this.sets);
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) {
            this.set.set(doc);
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.set = new FixedBitSet(context.reader().maxDoc());
            this.sets.add(this.set);
            return this;
        }

        public boolean needsScores() {
            return false;
        }
    }
}

