/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.AbstractAuthoritySetQuery;
import org.alfresco.solr.query.AllAccessCollector;
import org.alfresco.solr.query.BitsFilter;
import org.alfresco.solr.query.DocValuesCache;
import org.alfresco.solr.query.EmptyHybridBitSet;
import org.alfresco.solr.query.HybridBitSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrDenySetQuery
extends AbstractAuthoritySetQuery
implements PostFilter {
    public SolrDenySetQuery(String authorities) {
        super(authorities);
    }

    public int getCost() {
        return 201;
    }

    public void setCost(int cost) {
    }

    public void setCache(boolean cache) {
    }

    public boolean getCache() {
        return true;
    }

    public boolean getCacheSep() {
        return false;
    }

    public void setCacheSep(boolean cacheSep) {
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean requiresScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        String[] auths = this.authorities.substring(1).split(this.authorities.substring(0, 1));
        BitsFilter denyFilter = this.getACLFilter(auths, "DENIED", (SolrIndexSearcher)searcher);
        return new ConstantScoreQuery((Query)denyFilter).createWeight(searcher, false);
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        String[] auths = this.authorities.substring(1).split(this.authorities.substring(0, 1));
        try {
            HybridBitSet denySet = this.getACLSet(auths, "DENIED", (SolrIndexSearcher)searcher);
            if (denySet instanceof EmptyHybridBitSet) {
                return new AllAccessCollector();
            }
            return new AccessControlCollector(denySet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DENYSET").append(':');
        stringBuilder.append(this.authorities);
        return stringBuilder.toString();
    }

    class AccessControlCollector
    extends DelegatingCollector {
        private HybridBitSet aclIds;
        private NumericDocValues fieldValues;

        public AccessControlCollector(HybridBitSet aclIds) {
            this.aclIds = aclIds;
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.fieldValues = DocValuesCache.getNumericDocValues("ACLID", context.reader());
        }

        public void collect(int doc) throws IOException {
            long aclId = this.fieldValues.get(doc);
            if (!this.aclIds.get(aclId)) {
                super.collect(doc);
            }
        }
    }
}

