/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.AbstractAuthorityQuery;
import org.alfresco.solr.query.AbstractAuthorityQueryWeight;
import org.alfresco.solr.query.SolrDeniedScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrDeniedQuery
extends AbstractAuthorityQuery {
    public SolrDeniedQuery(String authority) {
        super(authority);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DENIED").append(':');
        stringBuilder.append(this.authority);
        return stringBuilder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean requiresScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrDenyQueryWeight((SolrIndexSearcher)searcher, this, this.authority);
    }

    private class SolrDenyQueryWeight
    extends AbstractAuthorityQueryWeight {
        public SolrDenyQueryWeight(SolrIndexSearcher searcher, Query query, String reader) throws IOException {
            super(searcher, false, query, "DENIED", reader);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return SolrDeniedScorer.createDenyScorer(this, context, this.searcher, SolrDeniedQuery.this.authority);
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(new Term("DENIED", SolrDeniedQuery.this.authority));
        }
    }
}

