/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.SolrCachingPathQuery;
import org.alfresco.solr.query.SolrCachingPathScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingPathWeight
extends Weight {
    private SolrIndexSearcher searcher;
    private Weight queryWeight;

    public SolrCachingPathWeight(SolrCachingPathQuery cachingPathQuery, SolrIndexSearcher searcher) throws IOException {
        super((Query)cachingPathQuery);
        this.searcher = searcher;
        this.queryWeight = cachingPathQuery.pathQuery.createWeight((IndexSearcher)searcher, false);
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getValueForNormalization() throws IOException {
        return 1.0f;
    }

    public void normalize(float norm, float topLevelBoost) {
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        return SolrCachingPathScorer.create(this, context, this.searcher, ((SolrCachingPathQuery)this.getQuery()).pathQuery);
    }

    public void extractTerms(Set<Term> terms) {
        this.queryWeight.extractTerms(terms);
    }
}

