/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.io.interceptor;

import java.io.IOException;
import org.alfresco.solr.security.SecretSharedPropertyCollector;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientUtil;

public class SharedSecretRequestInterceptor
implements HttpRequestInterceptor {
    private static volatile SharedSecretRequestInterceptor INSTANCE;

    private SharedSecretRequestInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedSecretRequestInterceptor getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SharedSecretRequestInterceptor> clazz = SharedSecretRequestInterceptor.class;
        synchronized (SharedSecretRequestInterceptor.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SharedSecretRequestInterceptor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        String secretName = SecretSharedPropertyCollector.getSecretHeader();
        String secretValue = SecretSharedPropertyCollector.getSecret();
        httpRequest.addHeader((Header)new BasicHeader(secretName, secretValue));
    }

    public static void register() {
        HttpClientUtil.removeRequestInterceptor((HttpRequestInterceptor)SharedSecretRequestInterceptor.getInstance());
        HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)SharedSecretRequestInterceptor.getInstance());
    }
}

