/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.transformer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.solr.AbstractAlfrescoDistributedIT;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@SolrTestCaseJ4.SuppressSSL
public class AlfrescoFieldMapperTransformerIT
extends AbstractAlfrescoDistributedIT {
    public static final String ALFRESCO_JSON = "{\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}]}";

    @BeforeClass
    public static void initData() throws Throwable {
        AlfrescoFieldMapperTransformerIT.initSolrServers(1, AlfrescoFieldMapperTransformerIT.getSimpleClassName(), null);
        AlfrescoFieldMapperTransformerIT.populateAlfrescoData();
    }

    @AfterClass
    public static void destroyData() {
        AlfrescoFieldMapperTransformerIT.dismissSolrServers();
    }

    @Test
    public void transformDocument_noDocTransformer_shouldReturnBasicFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocumentList results = resp.getResults();
        AlfrescoFieldMapperTransformerIT.assertEquals((String)"Expecting 5 rows", (long)5L, (long)results.size());
        SolrDocument doc = (SolrDocument)results.get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)doc.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)doc);
        String id = (String)doc.get((Object)"id");
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)id);
        Long dbid = (Long)doc.get((Object)"DBID");
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)dbid);
        String title = (String)doc.get((Object)"cm:title");
        AlfrescoFieldMapperTransformerIT.assertNull((Object)title);
        String owner = (String)doc.get((Object)"OWNER");
        AlfrescoFieldMapperTransformerIT.assertNull((Object)owner);
    }

    @Test
    public void transformDocument_docTransformer_shouldReturnAllFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "*,[fmap]", "sort", "id asc"}));
        SolrDocument docWithAllFields = (SolrDocument)resp.getResults().get(0);
        AlfrescoFieldMapperTransformerIT.assertTrue((docWithAllFields.size() > 3 ? 1 : 0) != 0);
        Long version2 = (Long)docWithAllFields.get((Object)"_version_");
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)version2);
        String owner = docWithAllFields.get((Object)"OWNER").toString();
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)owner);
        AlfrescoFieldMapperTransformerIT.assertEquals((Object)"[mike]", (Object)owner);
        String title = docWithAllFields.get((Object)"cm:title").toString();
        AlfrescoFieldMapperTransformerIT.assertEquals((Object)"[title1]", (Object)title);
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)title);
        Long dbid2 = (Long)docWithAllFields.get((Object)"DBID");
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)dbid2);
    }

    @Test
    public void transformDocument_docTransformerAndFieldsSelects_shouldReturnOnlySelectedFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "id,DBID,[fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocument docWithRequestedFields = (SolrDocument)resp.getResults().get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)docWithRequestedFields.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithRequestedFields.get((Object)"id"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithRequestedFields.get((Object)"DBID"));
    }

    @Test
    public void transformDocument_docTransformerNotDefaultFields_shouldReternOnlySelectedFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "id, cm_title,[fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocument docWithRequestedFields3 = (SolrDocument)resp.getResults().get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)docWithRequestedFields3.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithRequestedFields3.get((Object)"id"));
        String title = (String)docWithRequestedFields3.getFieldValue("cm_title");
        AlfrescoFieldMapperTransformerIT.assertEquals((Object)"title1", (Object)title);
    }

    @Test
    public void transformDocument_docTransformerSetTwice_shouldWorkWithoutErrors() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "id, cm_title,[fmap], [fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocument docWithRequestedFields3 = (SolrDocument)resp.getResults().get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)docWithRequestedFields3.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithRequestedFields3.get((Object)"id"));
        String title = (String)docWithRequestedFields3.getFieldValue("cm_title");
        AlfrescoFieldMapperTransformerIT.assertEquals((Object)"title1", (Object)title);
    }

    @Test
    public void transformDocument_docTransformerAndScoreRequested_shouldReturnScore() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "cm_name, score, [fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocumentList results = resp.getResults();
        SolrDocument docWithAllFields = (SolrDocument)results.get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)docWithAllFields.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_name"));
        Float score = (Float)docWithAllFields.get((Object)"score");
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)score);
    }

    @Test
    public void transformDocument_docTransformerFieldsAndScoreRequested_shouldReturnScoreAndSelectedFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "cm_title, cm_created, DBID, score, [fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocumentList results = resp.getResults();
        SolrDocument docWithAllFields = (SolrDocument)results.get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)4L, (long)docWithAllFields.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_title"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_created"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"score"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"DBID"));
    }

    @Test
    public void transformDocument_docTransformerGlobsFieldRequested_shouldReturnMatchedFields() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "cm?title, *name, [fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocumentList results = resp.getResults();
        SolrDocument docWithAllFields = (SolrDocument)results.get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)4L, (long)docWithAllFields.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_title"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm:title"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_name"));
    }

    @Test
    public void transformDocument_docTransformerIsUsedWithOtherTransformer_shouldExecuteBothTranformers() throws Exception {
        AlfrescoFieldMapperTransformerIT.putHandleDefaults();
        QueryResponse resp = this.query(AlfrescoFieldMapperTransformerIT.getDefaultTestClient(), true, ALFRESCO_JSON, AlfrescoFieldMapperTransformerIT.params((String[])new String[]{"q", "*", "qt", "/afts", "shards.qt", "/afts", "fl", "cm_title, [explain], [fmap]", "sort", "id asc"}));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)resp);
        SolrDocumentList results = resp.getResults();
        SolrDocument docWithAllFields = (SolrDocument)results.get(0);
        AlfrescoFieldMapperTransformerIT.assertEquals((long)2L, (long)docWithAllFields.size());
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"cm_title"));
        AlfrescoFieldMapperTransformerIT.assertNotNull((Object)docWithAllFields.get((Object)"[explain]"));
    }

    private static void populateAlfrescoData() throws Exception {
        AclChangeSet aclChangeSet = AlfrescoSolrUtils.getAclChangeSet(1);
        Acl acl = AlfrescoSolrUtils.getAcl(aclChangeSet);
        AclReaders aclReaders = AlfrescoSolrUtils.getAclReaders(aclChangeSet, acl, Collections.singletonList("joel"), Collections.singletonList("phil"), null);
        AlfrescoSolrUtils.indexAclChangeSet(aclChangeSet, Collections.singletonList(acl), Collections.singletonList(aclReaders));
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((Query)new TermQuery(new Term("id", "TRACKER!STATE!ACLTX")), BooleanClause.Occur.MUST));
        builder.add(new BooleanClause((Query)LegacyNumericRangeQuery.newLongRange((String)"S_ACLTXID", (Long)aclChangeSet.getId(), (Long)(aclChangeSet.getId() + 1L), (boolean)true, (boolean)false), BooleanClause.Occur.MUST));
        BooleanQuery waitForQuery = builder.build();
        AlfrescoFieldMapperTransformerIT.waitForDocCountAllCores((Query)waitForQuery, 1, 80000L);
        int numNodes = 5;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
        Transaction bigTxn = AlfrescoSolrUtils.getTransaction(0, numNodes);
        Date now = new Date();
        for (int i = 0; i < numNodes; ++i) {
            Node node = AlfrescoSolrUtils.getNode(bigTxn, acl, Node.SolrApiNodeStatus.UPDATED);
            nodes.add(node);
            NodeMetaData nodeMetaData = AlfrescoSolrUtils.getNodeMetaData(node, bigTxn, acl, "mike", null, false);
            nodeMetaData.getProperties().put(ContentModel.PROP_TITLE, new MLTextPropertyValue(Map.of(Locale.getDefault(), "title" + (i + 1))));
            nodeMetaData.getProperties().put(ContentModel.PROP_NAME, new StringPropertyValue("name" + (i + 1)));
            nodeMetaData.getProperties().put(ContentModel.PROP_CREATED, new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)now)));
            nodeMetaDatas.add(nodeMetaData);
        }
        AlfrescoFieldMapperTransformerIT.indexTransaction(bigTxn, nodes, nodeMetaDatas);
        AlfrescoFieldMapperTransformerIT.waitForDocCount((Query)new TermQuery(new Term("content@s___t@{http://www.alfresco.org/model/content/1.0}content", "world")), numNodes, 100000L);
    }
}

