/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.servlet;

import java.util.NoSuchElementException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.alfresco.solr.servlet.Solr4X509ServletFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Solr4X509ServletFilterTest {
    private Solr4X509ServletFilter cut;
    private MBeanServer mxServer;

    @Before
    public void setUp() {
        this.cut = new Solr4X509ServletFilter();
        try {
            this.mxServer = this.cut.mxServer();
        }
        catch (NoSuchElementException exception) {
            this.mxServer = MBeanServerFactory.createMBeanServer("A_DOMAIN");
        }
    }

    @After
    public void tearDown() {
        try {
            this.cut.mxServer().unregisterMBean((ObjectName)this.cut.connectorMBeanName().get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void mxServerNotFound() {
        MBeanServerFactory.releaseMBeanServer(this.mxServer);
        this.cut.mxServer();
    }

    @Test
    public void noAvailableConnectors() {
        Assert.assertFalse((boolean)this.cut.connectorMBeanName().isPresent());
        Assert.assertEquals((long)-1L, (long)this.cut.getHttpsPort());
    }

    @Test
    public void oneAvailableHttpsConnector() throws Exception {
        int expectedPort = 8443;
        this.registerConnector("https", 8443);
        Assert.assertEquals((long)8443L, (long)this.cut.getHttpsPort());
    }

    @Test
    public void httpAndHttpsConnectors() throws Exception {
        int expectedPort = 8443;
        this.registerConnector("http", 80);
        this.registerConnector("https", 8443);
        Assert.assertEquals((long)8443L, (long)this.cut.getHttpsPort());
    }

    @Test
    public void cannotGetHttpsPort() throws Exception {
        this.registerTouchyHttpsConnector();
        Assert.assertEquals((long)-1L, (long)this.cut.getHttpsPort());
    }

    @Test
    public void onlyHttpConnector() throws Exception {
        this.registerConnector("http", 8080);
        Assert.assertFalse((boolean)this.cut.connectorMBeanName().isPresent());
        Assert.assertEquals((long)-1L, (long)this.cut.getHttpsPort());
    }

    private void registerConnector(String scheme, int port) throws Exception {
        ObjectName name = new ObjectName("A_DOMAIN", "created", String.valueOf(System.nanoTime()));
        this.cut.mxServer().registerMBean(new TestConnector(port, scheme), name);
    }

    private void registerTouchyHttpsConnector() throws Exception {
        ObjectName name = new ObjectName("A_DOMAIN", "created", String.valueOf(System.nanoTime()));
        this.cut.mxServer().registerMBean(new TestConnector(0, "https"){

            @Override
            public int getPort() {
                throw new RuntimeException("Don't ask me the port number!");
            }
        }, name);
    }

    private class TestConnector
    implements TestConnectorMBean {
        private int port;
        private String scheme;

        TestConnector(int port, String scheme) {
            this.port = port;
            this.scheme = scheme;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void setPort(int port) {
            this.port = port;
        }
    }

    public static interface TestConnectorMBean {
        public String getScheme();

        public void setScheme(String var1);

        public int getPort();

        public void setPort(int var1);
    }
}

