/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query.cmis;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrUtils;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.query.cmis.LoadCMISData;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Before;
import org.junit.Test;

public class TrieFieldsCMISTest
extends LoadCMISData {
    @Before
    public void setup() throws Exception {
        TrieFieldsCMISTest.addTypeTestData(testCMISFolder00NodeRef, testCMISRootNodeRef, testCMISBaseFolderNodeRef, testCMISBaseFolderQName, testCMISFolder00QName, testCMISDate00);
        this.addTrieTypeTestData(testCMISFolder00NodeRef, testCMISRootNodeRef, testCMISBaseFolderNodeRef, testCMISBaseFolderQName, testCMISFolder00QName, testCMISDate00);
    }

    private void addTrieTypeTestData(NodeRef folder00NodeRef, NodeRef rootNodeRef, NodeRef baseFolderNodeRef, QName baseFolderQName, QName folder00QName, Date date00) throws IOException {
        HashMap<QName, PropertyValue> content00Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc00 = new MLTextPropertyValue();
        desc00.addValue(Locale.ENGLISH, "Trie test1");
        content00Properties.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)desc00);
        content00Properties.put(ContentModel.PROP_TITLE, (PropertyValue)desc00);
        content00Properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue("Trie test1"));
        content00Properties.put(ContentModel.PROP_CREATED, (PropertyValue)new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
        StringPropertyValue firstIntValue = new StringPropertyValue("98198");
        content00Properties.put(SINGLE_INTEGER, (PropertyValue)firstIntValue);
        StringPropertyValue firstLongValue = new StringPropertyValue("3956650");
        content00Properties.put(SINGLE_LONG, (PropertyValue)firstLongValue);
        NodeRef content00NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
        QName content00QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Trie test1");
        ChildAssociationRef content00CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content00QName, content00NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(TrieFieldsCMISTest.getCore(), dataModel, 1, 300, 1, extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content00Properties, null, "andy", new ChildAssociationRef[]{content00CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content00QName.toString()}, content00NodeRef, true);
        HashMap<QName, PropertyValue> content01Properties = new HashMap<QName, PropertyValue>();
        MLTextPropertyValue desc01 = new MLTextPropertyValue();
        desc01.addValue(Locale.ENGLISH, "Trie test2");
        content01Properties.put(ContentModel.PROP_DESCRIPTION, (PropertyValue)desc01);
        content01Properties.put(ContentModel.PROP_TITLE, (PropertyValue)desc01);
        content01Properties.put(ContentModel.PROP_NAME, (PropertyValue)new StringPropertyValue("Trie test2"));
        content01Properties.put(ContentModel.PROP_CREATED, (PropertyValue)new StringPropertyValue((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date00)));
        StringPropertyValue secondIntValue = new StringPropertyValue("98200");
        content01Properties.put(SINGLE_INTEGER, (PropertyValue)secondIntValue);
        StringPropertyValue secondLongValue = new StringPropertyValue("3956651");
        content01Properties.put(SINGLE_LONG, (PropertyValue)secondLongValue);
        NodeRef content01NodeRef = new NodeRef(new StoreRef("workspace", "SpacesStore"), AlfrescoSolrUtils.createGUID());
        QName content01QName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Trie test1");
        ChildAssociationRef content01CAR = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, folder00NodeRef, content01QName, content01NodeRef, true, 0);
        AlfrescoSolrUtils.addNode(TrieFieldsCMISTest.getCore(), dataModel, 1, 301, 1, extendedContent, new QName[]{ContentModel.ASPECT_OWNABLE, ContentModel.ASPECT_TITLED}, content01Properties, null, "andy", new ChildAssociationRef[]{content01CAR}, new NodeRef[]{baseFolderNodeRef, rootNodeRef, folder00NodeRef}, new String[]{"/" + baseFolderQName.toString() + "/" + folder00QName.toString() + "/" + content01QName.toString()}, content01NodeRef, true);
    }

    @Test
    public void checkOrder() throws IOException {
        TrieFieldsCMISTest.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 98218"), this.expectedDocCount(0));
        TrieFieldsCMISTest.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 98198"), this.expectedDocCount(1));
        TrieFieldsCMISTest.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleInteger = 98200"), this.expectedDocCount(1));
        TrieFieldsCMISTest.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 3956650"), this.expectedDocCount(1));
        TrieFieldsCMISTest.assertQ((SolrQueryRequest)this.qurySolr("SELECT * FROM cmistest:extendedContent WHERE cmistest:singleLong = 3956651"), this.expectedDocCount(1));
    }
}

