/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
public class AlfrescoSolrSpellcheckerIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoSolrSpellcheckerIT.initAlfrescoCore("schema.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.clearIndex();
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
    }

    @Test
    public void testSpellcheckOutputFormat() throws Exception {
        this.assertU(AlfrescoSolrSpellcheckerIT.delQ("*:*"));
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
        String[] doc = new String[]{"id", "1", "suggest", "YYYYYYY BBBBBBB", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYYYYY BBBBBBB"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc));
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
        String[] doc1 = new String[]{"id", "2", "suggest", "YYYYYYA", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "YYYYYYA"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc1));
        String[] doc2 = new String[]{"id", "3", "suggest", "BBBBBBBB", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "BBBBBBBB"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc2));
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
        String[] doc3 = new String[]{"id", "4", "suggest", "CCCC", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "CCCC"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc3));
        String[] doc4 = new String[]{"id", "5", "suggest", "DDDD", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "DDDD"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc4));
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
        String[] doc5 = new String[]{"id", "6", "suggest", "EEEE", "_version_", "0", "content@s___t@{http://www.alfresco.org/model/content/1.0}content", "EEEE"};
        this.assertU(AlfrescoSolrSpellcheckerIT.adoc(doc5));
        this.assertU(AlfrescoSolrSpellcheckerIT.commit(new String[0]));
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("spellcheck.q", new String[]{"YYYYY BBBBB"});
        params.add("qt", new String[]{"/afts"});
        params.add("spellcheck", new String[]{"true"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        AbstractAlfrescoSolrIT.SolrServletRequest req = this.areq(params, "{\"query\":\"(YYYYY BBBBB AND (id:(1 2 3 4 5 6)))\",\"locales\":[\"en\"], \"templates\": [{\"name\":\"t1\", \"template\":\"%cm:content\"}], \"authorities\": [\"joel\"], \"tenants\": []}");
        AlfrescoSolrSpellcheckerIT.assertQ((SolrQueryRequest)req, "*[count(//lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'])=2]", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][1]/int[@name='hits'][.='2']", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][2]/int[@name='hits'][.='1']", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][1]/str[@name='collationQueryString'][.='yyyyyya bbbbbbb']", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][2]/str[@name='collationQueryString'][.='yyyyyyy bbbbbbb']", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][1]/str[@name='collationQuery'][.='(yyyyyya bbbbbbb AND (id:(1 2 3 4 5 6)))']", "/response/lst[@name='spellcheck']/lst[@name='suggestions']/lst[@name='collation'][2]/str[@name='collationQuery'][.='(yyyyyyy bbbbbbb AND (id:(1 2 3 4 5 6)))']");
    }
}

