/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.ArrayList;
import java.util.Random;
import org.alfresco.solr.AbstractAlfrescoSolrIT;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@LuceneTestCase.SuppressCodecs(value={"Appending", "Lucene3x", "Lucene40", "Lucene41", "Lucene42", "Lucene43", "Lucene44", "Lucene45", "Lucene46", "Lucene47", "Lucene48", "Lucene49"})
public class AlfrescoReRankQParserPluginIT
extends AbstractAlfrescoSolrIT {
    @BeforeClass
    public static void beforeClass() throws Exception {
        AlfrescoReRankQParserPluginIT.initAlfrescoCore("schema-rerank.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.clearIndex();
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
    }

    @Test
    public void testReRankQueries() throws Exception {
        this.assertU(AlfrescoReRankQParserPluginIT.delQ("*:*"));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc = new String[]{"id", "1", "term_s", "YYYY", "group_s", "group1", "test_ti", "5", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc1 = new String[]{"id", "2", "term_s", "YYYY", "group_s", "group1", "test_ti", "50", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc1));
        String[] doc2 = new String[]{"id", "3", "term_s", "YYYY", "test_ti", "5000", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc2));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc3 = new String[]{"id", "4", "term_s", "YYYY", "test_ti", "500", "test_tl", "1000", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc3));
        String[] doc4 = new String[]{"id", "5", "term_s", "YYYY", "group_s", "group2", "test_ti", "4", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc4));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc5 = new String[]{"id", "6", "term_s", "YYYY", "group_s", "group2", "test_ti", "10", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc5));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        Random random = new Random();
        boolean scale = random.nextBoolean();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=200 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"term_s:YYYY"});
        params.add("rqq", new String[]{"{!edismax bf=$bff}*:*"});
        params.add("bff", new String[]{"field(test_ti)"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='3.0']", "//result/doc[2]/float[@name='id'][.='4.0']", "//result/doc[3]/float[@name='id'][.='2.0']", "//result/doc[4]/float[@name='id'][.='6.0']", "//result/doc[5]/float[@name='id'][.='1.0']", "//result/doc[6]/float[@name='id'][.='5.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"{!edismax bq=$bqq2}*:*"});
        params.add("bqq2", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='2.0']", "//result/doc[2]/float[@name='id'][.='6.0']", "//result/doc[3]/float[@name='id'][.='5.0']", "//result/doc[4]/float[@name='id'][.='4.0']", "//result/doc[5]/float[@name='id'][.='3.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"{!edismax bq=$bqq2}*:*"});
        params.add("bqq2", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        params.add("sort", new String[]{"score desc"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='2.0']", "//result/doc[2]/float[@name='id'][.='6.0']", "//result/doc[3]/float[@name='id'][.='5.0']", "//result/doc[4]/float[@name='id'][.='4.0']", "//result/doc[5]/float[@name='id'][.='3.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"{!edismax bq=$bqq2}*:*"});
        params.add("bqq2", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        params.add("sort", new String[]{"score desc,test_ti asc"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='2.0']", "//result/doc[2]/float[@name='id'][.='6.0']", "//result/doc[3]/float[@name='id'][.='5.0']", "//result/doc[4]/float[@name='id'][.='4.0']", "//result/doc[5]/float[@name='id'][.='3.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='2.0']", "//result/doc[2]/float[@name='id'][.='6.0']", "//result/doc[3]/float[@name='id'][.='5.0']", "//result/doc[4]/float[@name='id'][.='4.0']", "//result/doc[5]/float[@name='id'][.='3.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=1 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='6.0']", "//result/doc[2]/float[@name='id'][.='5.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='3.0']", "//result/doc[5]/float[@name='id'][.='2.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=0 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='6.0']", "//result/doc[2]/float[@name='id'][.='5.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='3.0']", "//result/doc[5]/float[@name='id'][.='2.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=2 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"test_ti:4^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"10"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='5.0']", "//result/doc[2]/float[@name='id'][.='6.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='3.0']", "//result/doc[5]/float[@name='id'][.='2.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 reRankWeight=0 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"5"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=5]", "//result/doc[1]/float[@name='id'][.='6.0']", "//result/doc[2]/float[@name='id'][.='5.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='3.0']", "//result/doc[5]/float[@name='id'][.='2.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"test_ti:[0 TO 2000]"});
        params.add("rqq", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=5]", "//result/doc[1]/float[@name='id'][.='6.0']", "//result/doc[2]/float[@name='id'][.='5.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='2.0']", "//result/doc[5]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"*:* OR test_ti:[0 TO 2000]"});
        params.add("rqq", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=6]", "//result/doc[1]/float[@name='id'][.='6.0']", "//result/doc[2]/float[@name='id'][.='5.0']", "//result/doc[3]/float[@name='id'][.='4.0']", "//result/doc[4]/float[@name='id'][.='3.0']", "//result/doc[5]/float[@name='id'][.='2.0']", "//result/doc[6]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=3 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60"});
        params.add("rqq", new String[]{"id:1^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"4"});
        params.add("rows", new String[]{"5"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=2]", "//result/doc[1]/float[@name='id'][.='2.0']", "//result/doc[2]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=6 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50"});
        params.add("rqq", new String[]{"id:1^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"1"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=1]", "//result/doc[1]/float[@name='id'][.='1.0']");
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=3 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"term_s:NNNN"});
        params.add("rqq", new String[]{"id:1^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"4"});
        params.add("rows", new String[]{"5"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=0]");
    }

    @Test
    public void testOverRank() throws Exception {
        this.assertU(AlfrescoReRankQParserPluginIT.delQ("*:*"));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        boolean scale = new Random().nextBoolean();
        String[] doc = new String[]{"id", "1", "term_s", "YYYY", "group_s", "group1", "test_ti", "5", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc));
        String[] doc1 = new String[]{"id", "2", "term_s", "YYYY", "group_s", "group1", "test_ti", "50", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc1));
        String[] doc2 = new String[]{"id", "3", "term_s", "YYYY", "test_ti", "5000", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc2));
        String[] doc3 = new String[]{"id", "4", "term_s", "YYYY", "test_ti", "500", "test_tl", "1000", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc3));
        String[] doc4 = new String[]{"id", "5", "term_s", "YYYY", "group_s", "group2", "test_ti", "4", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc4));
        String[] doc5 = new String[]{"id", "6", "term_s", "YYYY", "group_s", "group2", "test_ti", "10", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc5));
        String[] doc6 = new String[]{"id", "7", "term_s", "YYYY", "group_s", "group1", "test_ti", "5", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc6));
        String[] doc7 = new String[]{"id", "8", "term_s", "YYYY", "group_s", "group1", "test_ti", "50", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc7));
        String[] doc8 = new String[]{"id", "9", "term_s", "YYYY", "test_ti", "5000", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc8));
        String[] doc9 = new String[]{"id", "10", "term_s", "YYYY", "test_ti", "500", "test_tl", "1000", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc9));
        String[] doc10 = new String[]{"id", "11", "term_s", "YYYY", "group_s", "group2", "test_ti", "4", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc10));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=11 reRankWeight=2 scale=" + scale + "}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"{!edismax bq=$bqq1}*:*"});
        params.add("bqq1", new String[]{"id:1^10 id:2^20 id:3^30 id:4^40 id:5^50 id:6^60 id:7^70 id:8^80 id:9^90 id:10^100 id:11^110"});
        params.add("rqq", new String[]{"test_ti:50^1000"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"2"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=2]", "//result/doc[1]/float[@name='id'][.='8.0']", "//result/doc[2]/float[@name='id'][.='2.0']");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScale() throws Exception {
        float score;
        this.assertU(AlfrescoReRankQParserPluginIT.delQ("*:*"));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc = new String[]{"id", "1", "term_s", "YYYY", "group_s", "group1", "test_ti", "5", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc1 = new String[]{"id", "2", "term_s", "YYYY", "group_s", "group1", "test_ti", "50", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc1));
        String[] doc2 = new String[]{"id", "3", "term_s", "YYYY", "test_ti", "5000", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc2));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc3 = new String[]{"id", "4", "term_s", "YYYY", "test_ti", "500", "test_tl", "1000", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc3));
        String[] doc4 = new String[]{"id", "5", "term_s", "YYYY", "group_s", "group2", "test_ti", "4", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc4));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        String[] doc5 = new String[]{"id", "6", "term_s", "YYYY", "group_s", "group2", "test_ti", "10", "test_tl", "100", "test_tf", "200"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc5));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=200 scale=false}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"term_s:YYYY"});
        params.add("rqq", new String[]{"{!edismax bf=$bff}id:(1 2 4 5 6)"});
        params.add("bff", new String[]{"field(test_ti)"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        SolrQueryResponse res = null;
        try (SolrQueryRequest req = AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]);){
            res = AlfrescoReRankQParserPluginIT.queryAndResponse(null, req);
        }
        NamedList vals = res.getValues();
        ResultContext resultContext = (ResultContext)vals.get("response");
        DocList docs = resultContext.getDocList();
        DocIterator it = docs.iterator();
        float max = -3.4028235E38f;
        ArrayList<Float> scores = new ArrayList<Float>();
        while (it.hasNext()) {
            it.next();
            float score2 = it.score();
            max = Math.max(score2, max);
            scores.add(Float.valueOf(score2));
        }
        float[] scaledScores = new float[scores.size()];
        for (int i = 0; i < scaledScores.length; ++i) {
            score = ((Float)scores.get(i)).floatValue();
            scaledScores[i] = i < 5 ? score / max + 1.0f : score / max;
        }
        params = new ModifiableSolrParams();
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=200 scale=true}"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"term_s:YYYY"});
        params.add("rqq", new String[]{"{!edismax bf=$bff}id:(1 2 4 5 6)"});
        params.add("bff", new String[]{"field(test_ti)"});
        params.add("fl", new String[]{"id,score"});
        params.add("start", new String[]{"0"});
        params.add("rows", new String[]{"6"});
        req = AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]);
        try {
            res = AlfrescoReRankQParserPluginIT.queryAndResponse(null, req);
        }
        finally {
            req.close();
        }
        vals = res.getValues();
        resultContext = (ResultContext)vals.get("response");
        docs = resultContext.getDocList();
        it = docs.iterator();
        int index = 0;
        while (it.hasNext()) {
            it.next();
            score = it.score();
            float scaledScore = scaledScores[index++];
            Assert.assertEquals((String)"score should be equal to scaled score", (double)score, (double)scaledScore, (double)1.0E-5);
        }
        req.close();
    }

    @Test
    public void testInsaneAmoutOfRows() throws Exception {
        String[] doc = new String[]{"id", "1", "term_s", "YYYY", "group_s", "group1", "test_ti", "5", "test_tl", "10", "test_tf", "2000"};
        this.assertU(AlfrescoReRankQParserPluginIT.adoc(doc));
        this.assertU(AlfrescoReRankQParserPluginIT.commit(new String[0]));
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("qt", new String[]{"/afts"});
        params.add("df", new String[]{"TEXT"});
        params.add("q", new String[]{"term_s:YYYY"});
        params.add("rows", new String[]{"200000001"});
        params.add("rq", new String[]{"{!alfrescoReRank reRankQuery=$rqq reRankDocs=3 reRankWeight=2 }"});
        params.add("rqq", new String[]{"{!edismax bf=$bff}*:*"});
        params.add("bff", new String[]{"field(test_ti)"});
        AlfrescoReRankQParserPluginIT.assertQ(AlfrescoReRankQParserPluginIT.req((SolrParams)params, new String[0]), "*[count(//doc)=1]");
    }
}

