/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.basics;

import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.util.LuceneTestCase;

public class RandomSupplier {
    protected Random randomGenerator;
    public RandVal rint = new RandVal(){

        @Override
        public Object val() {
            return RandomSupplier.this.randomGenerator.nextInt();
        }
    };
    public RandVal rlong = new RandVal(){

        @Override
        public Object val() {
            return RandomSupplier.this.randomGenerator.nextLong();
        }
    };
    public RandVal rfloat = new RandVal(){

        @Override
        public Object val() {
            return Float.valueOf(RandomSupplier.this.randomGenerator.nextFloat());
        }
    };
    public RandVal rdouble = new RandVal(){

        @Override
        public Object val() {
            return RandomSupplier.this.randomGenerator.nextDouble();
        }
    };
    public RandVal rdate = new RandDate();
    public RandVal[] randVals = new RandVal[]{this.rint, this.rfloat, this.rfloat, this.rdouble, this.rdouble, this.rlong, this.rlong, this.rdate, this.rdate};

    public RandomSupplier() {
        this.randomGenerator = new Random(LuceneTestCase.random().nextLong());
    }

    public Random getRandomGenerator() {
        return this.randomGenerator;
    }

    public RandVal[] getRandValues() {
        return this.randVals;
    }

    public Object[] getRandFields(String[] fields, RandVal[] randVals) {
        Object[] o = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            o[i * 2] = fields[i];
            o[i * 2 + 1] = randVals[i].uval();
        }
        return o;
    }

    public static abstract class RandVal {
        public static Set<Object> uniqueValues = new HashSet<Object>();

        public abstract Object val();

        public Object uval() {
            Object v;
            while (!uniqueValues.add(v = this.val())) {
            }
            return v;
        }
    }

    public class RandDate
    extends RandVal {
        @Override
        public Object val() {
            long v = RandomSupplier.this.randomGenerator.nextLong();
            Date d = new Date(v);
            return d.toInstant().toString();
        }
    }
}

