/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.schema.highlight;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import org.alfresco.solr.AlfrescoAnalyzerWrapper;
import org.alfresco.solr.schema.highlight.CompositeReader;
import org.alfresco.util.Pair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;

public final class LanguagePrefixedTokenStream
extends Tokenizer {
    static final String FALLBACK_TEXT_FIELD_TYPE_NAME = "text___";
    static final String LOCALISED_FIELD_TYPE_NAME_PREFIX = "text_";
    static final String LOCALISED_HIGHLIGHTING_FIELD_TYPE_NAME_PREFIX = "highlighted_text_";
    private static final char LANGUAGE_SENTINEL_TOKEN = '\u0000';
    private static final char[] EMPTY_CHARSTREAM = new char[0];
    protected String fieldName;
    protected IndexSchema indexSchema;
    protected AlfrescoAnalyzerWrapper.Mode mode;
    protected Analyzer analyzer;
    private TokenStream stream;
    private int localeMarkerLength;
    private CharTermAttribute decoratorTerm;
    private PositionIncrementAttribute decoratorPositionIncrement;
    private OffsetAttribute decoratorOffset;
    private TypeAttribute decoratorType;
    private CharTermAttribute decoratedTerm;
    private PositionIncrementAttribute decoratedPositionInc;
    private OffsetAttribute decoratedOffset;
    private TypeAttribute decoratedType;

    LanguagePrefixedTokenStream(IndexSchema indexSchema, String fieldName, AlfrescoAnalyzerWrapper.Mode mode) {
        this.indexSchema = indexSchema;
        this.fieldName = fieldName;
        this.mode = mode;
        this.decoratorTerm = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.decoratorPositionIncrement = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.decoratorOffset = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.decoratorType = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public void reset() throws IOException {
        super.reset();
        this.clearAttributes();
        Pair<Optional<String>, Reader> info = this.languageAndReaderFrom(this.input);
        this.localeMarkerLength = this.localeMarkerLength((Optional)info.getFirst());
        String language = ((Optional)info.getFirst()).orElse("__");
        this.analyzer = this.analyzer(language);
        this.stream = this.analyzer.tokenStream(this.fieldName, (Reader)info.getSecond());
        this.stream.reset();
        this.createOrRefreshAttributesOfDecoratedStream();
    }

    public boolean incrementToken() throws IOException {
        boolean result = this.stream.incrementToken();
        if (result) {
            this.copyAttributesFromDecorateeToDecorator();
        }
        return result;
    }

    public void end() throws IOException {
        super.end();
        this.stream.end();
    }

    public void close() throws IOException {
        super.close();
        this.stream.close();
    }

    Pair<Optional<String>, Reader> languageAndReaderFrom(Reader reader) throws IOException {
        char[] prefix = new char[5];
        int read = reader.read(prefix);
        if (read < prefix.length) {
            return new Pair(Optional.empty(), (Object)(this.isValidLocaleMarker(prefix) ? new CharArrayReader(EMPTY_CHARSTREAM) : new CharArrayReader(prefix, 0, Math.max(read, 0))));
        }
        if (this.isValidLocaleMarker(prefix)) {
            if (this.isTwoCharsLanguageCode(prefix)) {
                CharArrayReader alreadyConsumedCharsReader = new CharArrayReader(prefix, prefix.length - 1, 1);
                return new Pair(Optional.of(new String(prefix, 1, 2).toLowerCase()), (Object)new CompositeReader(alreadyConsumedCharsReader, reader));
            }
            return new Pair(Optional.of(new String(prefix, 1, 3).toLowerCase()), (Object)reader);
        }
        CharArrayReader alreadyConsumedCharsReader = new CharArrayReader(prefix);
        return new Pair(Optional.empty(), (Object)new CompositeReader(alreadyConsumedCharsReader, reader));
    }

    private boolean isTwoCharsLanguageCode(char[] marker) {
        return marker.length == 5 && marker[3] == '\u0000';
    }

    private boolean isValidLocaleMarker(char[] prefix) {
        int length = prefix.length;
        return prefix[0] == '\u0000' && (prefix[length - 1] == '\u0000' || prefix[length - 2] == '\u0000');
    }

    Analyzer analyzer(String language) {
        FieldType localisedFieldType = Optional.ofNullable(this.indexSchema.getFieldTypeByName(this.highlightingFieldTypeName(language))).orElseGet(() -> this.indexSchema.getFieldTypeByName(this.localisedFieldTypeName(language)));
        FieldType targetFieldType = Optional.ofNullable(localisedFieldType).orElseGet(() -> this.indexSchema.getFieldTypeByName(FALLBACK_TEXT_FIELD_TYPE_NAME));
        switch (this.mode) {
            case QUERY: {
                return targetFieldType.getQueryAnalyzer();
            }
        }
        return targetFieldType.getIndexAnalyzer();
    }

    void copyAttributesFromDecorateeToDecorator() {
        this.decoratorTerm.copyBuffer(this.decoratedTerm.buffer(), 0, this.decoratedTerm.length());
        this.decoratorOffset.setOffset(this.decoratedOffset.startOffset() + this.localeMarkerLength, this.decoratedOffset.endOffset() + this.localeMarkerLength);
        this.decoratorType.setType(this.decoratedType.type());
        this.decoratorPositionIncrement.setPositionIncrement(this.decoratedPositionInc.getPositionIncrement());
    }

    void createOrRefreshAttributesOfDecoratedStream() {
        this.decoratedTerm = (CharTermAttribute)this.stream.addAttribute(CharTermAttribute.class);
        this.decoratedPositionInc = (PositionIncrementAttribute)this.stream.addAttribute(PositionIncrementAttribute.class);
        this.decoratedOffset = (OffsetAttribute)this.stream.addAttribute(OffsetAttribute.class);
        this.decoratedType = (TypeAttribute)this.stream.addAttribute(TypeAttribute.class);
    }

    String highlightingFieldTypeName(String language) {
        return LOCALISED_HIGHLIGHTING_FIELD_TYPE_NAME_PREFIX + language;
    }

    String localisedFieldTypeName(String language) {
        return LOCALISED_FIELD_TYPE_NAME_PREFIX + language;
    }

    int localeMarkerLength(Optional<String> language) {
        return language.map(String::length).map(length -> length + 2).orElse(0);
    }
}

