/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrOwnerScorer
extends AbstractSolrCachingScorer {
    SolrOwnerScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrOwnerScorer createOwnerScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authority) throws IOException {
        if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.USER) {
            DocSet ownedDocs = (DocSet)searcher.cacheLookup("alfrescoOwnerCache", (Object)authority);
            if (ownedDocs == null) {
                ownedDocs = searcher.getDocSet((Query)new TermQuery(new Term("OWNER", authority)));
                searcher.cacheInsert("alfrescoOwnerCache", (Object)authority, (Object)ownedDocs);
            }
            return new SolrOwnerScorer(weight, ownedDocs, context, searcher);
        }
        return new SolrOwnerScorer(weight, (DocSet)new BitDocSet(new FixedBitSet(0)), context, searcher);
    }
}

