/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.Properties;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.parsers.FTSQueryParser;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.Lucene4QueryParserAdaptor;
import org.alfresco.solr.query.Solr4QueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Version;
import org.apache.solr.core.CoreDescriptorDecorator;
import org.apache.solr.request.SolrQueryRequest;

public class Lucene4QueryBuilderContextSolrImpl
implements QueryBuilderContext<Query, Sort, ParseException> {
    private Solr4QueryParser lqp;
    private NamespacePrefixResolver namespacePrefixResolver;
    private QueryParserAdaptor<Query, Sort, ParseException> lqpa;

    public Lucene4QueryBuilderContextSolrImpl(DictionaryService dictionaryService, NamespacePrefixResolver namespacePrefixResolver, TenantService tenantService, SearchParameters searchParameters, MLAnalysisMode defaultSearchMLAnalysisMode, SolrQueryRequest req, AlfrescoSolrDataModel model, FTSQueryParser.RerankPhase rerankPhase) {
        this.lqp = new Solr4QueryParser(req, Version.LATEST, searchParameters.getDefaultFieldName(), req.getSchema().getQueryAnalyzer(), rerankPhase);
        this.lqp.setDictionaryService(dictionaryService);
        this.lqp.setNamespacePrefixResolver(namespacePrefixResolver);
        this.lqp.setTenantService(tenantService);
        this.lqp.setSearchParameters(searchParameters);
        Properties props = new CoreDescriptorDecorator(req.getCore().getCoreDescriptor()).getProperties();
        int topTermSpanRewriteLimit = Integer.parseInt(props.getProperty("alfresco.topTermSpanRewriteLimit", "1000"));
        this.lqp.setTopTermSpanRewriteLimit(topTermSpanRewriteLimit);
        this.lqpa = new Lucene4QueryParserAdaptor(this.lqp);
    }

    public QueryParserAdaptor<Query, Sort, ParseException> getLuceneQueryParserAdaptor() {
        return this.lqpa;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }
}

