/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.simplexml;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.carrot2.shaded.guava.common.collect.ImmutableSet;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="value")
public class SimpleXmlWrapperValue {
    @Attribute(required=false)
    String type;
    @Attribute(required=false)
    String value;
    @Element(required=false)
    Object wrapper;
    private static final Set<Class<?>> TO_STRING_VALUE_OF_TYPES = ImmutableSet.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, (Object[])new Class[]{Boolean.class});

    static SimpleXmlWrapperValue wrap(Object value) {
        SimpleXmlWrapperValue wrapper = new SimpleXmlWrapperValue();
        if (value == null) {
            return wrapper;
        }
        Class<?> valueType = value.getClass();
        if (TO_STRING_VALUE_OF_TYPES.contains(valueType)) {
            wrapper.value = value.toString();
            wrapper.type = valueType.getName();
        } else if (value instanceof Character) {
            wrapper.value = value.toString();
            wrapper.type = Character.class.getName();
        } else if (value instanceof String) {
            wrapper.value = (String)value;
            wrapper.type = null;
        } else if (Class.class.isInstance(value)) {
            wrapper.value = ((Class)value).getName();
            wrapper.type = Class.class.getName();
        } else if (value instanceof Enum) {
            Enum e = (Enum)value;
            wrapper.value = e.name();
            wrapper.type = e.getDeclaringClass().getName();
        } else {
            wrapper.wrapper = value.getClass().getAnnotation(Root.class) != null ? value : SimpleXmlWrapperValue.wrapCustom(value);
        }
        return wrapper;
    }

    Object unwrap() {
        if (this.value != null) {
            Class<?> valueType;
            if (StringUtils.isEmpty((String)this.type)) {
                this.type = String.class.getName();
            }
            if (TO_STRING_VALUE_OF_TYPES.contains(valueType = SimpleXmlWrapperValue.loadClassWrapAsRuntime(this.type))) {
                try {
                    Method valueOfMethod = valueType.getMethod("valueOf", String.class);
                    return valueOfMethod.invoke(null, this.value);
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsRuntimeException(e);
                }
            }
            if (Character.class.getName().equals(this.type)) {
                return this.value.length() > 0 ? Character.valueOf(this.value.charAt(0)) : null;
            }
            if (String.class.getName().equals(this.type)) {
                return this.value;
            }
            if (Class.class.getName().equals(this.type)) {
                return SimpleXmlWrapperValue.loadClassWrapAsRuntime(this.value);
            }
            if (Enum.class.isAssignableFrom(valueType)) {
                return Enum.valueOf(valueType, this.value);
            }
        } else if (this.wrapper != null) {
            if (this.wrapper instanceof ISimpleXmlWrapper) {
                return ((ISimpleXmlWrapper)this.wrapper).getValue();
            }
            return this.wrapper;
        }
        return null;
    }

    static <T> ISimpleXmlWrapper<T> wrapCustom(T value) {
        Class<ISimpleXmlWrapper<?>> wrapperClass = SimpleXmlWrappers.getWrapper(value);
        if (wrapperClass != null) {
            ISimpleXmlWrapper<?> newInstance;
            try {
                newInstance = wrapperClass.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
            newInstance.setValue(value);
            return newInstance;
        }
        return null;
    }

    private static Class<?> loadClassWrapAsRuntime(String className) {
        try {
            return ReflectionUtils.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
    }
}

