/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationFactory;
import org.carrot2.matrix.factorization.LocalNonnegativeMatrixFactorizationFactory;
import org.carrot2.matrix.factorization.NonnegativeMatrixFactorizationEDFactory;
import org.carrot2.matrix.factorization.NonnegativeMatrixFactorizationKLFactory;
import org.carrot2.matrix.factorization.seeding.KMeansSeedingStrategyFactory;
import org.carrot2.matrix.factorization.seeding.RandomSeedingStrategyFactory;
import org.carrot2.shaded.guava.common.collect.Maps;

public class IterationNumberGuesser {
    private static Map<List<Object>, double[]> allKnownCoefficients = Maps.newHashMap();

    public static boolean setEstimatedIterationsNumber(IterativeMatrixFactorizationFactory factory, DoubleMatrix2D A, FactorizationQuality qualityLevel) {
        double[] coefficients = allKnownCoefficients.get(Arrays.asList(new Object[]{factory.getClass(), factory.getSeedingFactory().getClass(), qualityLevel}));
        if (coefficients != null) {
            double columns = Math.sqrt((double)(A.rows() * A.columns()) / 2.8);
            if (columns < 50.0 || columns > 400.0 || factory.getK() < 5 || factory.getK() > 50) {
                return false;
            }
            int iterations = (int)(columns * coefficients[0] + (double)factory.getK() * coefficients[1] + coefficients[2]);
            factory.setMaxIterations((int)((double)iterations * 0.6));
            return true;
        }
        return false;
    }

    static {
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.0166, 0.3333, 8.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.6, 12.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationKLFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.0186, 0.8222, 17.3555});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.005, 0.0, 6.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.005, 0.0, 10.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{NonnegativeMatrixFactorizationEDFactory.class, KMeansSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.005, 0.0, 20.0});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.LOW}), new double[]{-0.014, 0.1, 7.5});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.MEDIUM}), new double[]{-0.0175, 0.15, 11.3333});
        allKnownCoefficients.put(Arrays.asList(new Object[]{LocalNonnegativeMatrixFactorizationFactory.class, RandomSeedingStrategyFactory.class, FactorizationQuality.HIGH}), new double[]{-0.02333, 0.2, 16.8888});
    }

    public static enum FactorizationQuality {
        LOW,
        MEDIUM,
        HIGH;


        public String toString() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

