/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@AlfrescoPublicApi
public class ISO8601DateFormat {
    private static ThreadLocal<Map<TimeZone, Calendar>> calendarThreadLocal = new ThreadLocal();
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public static Calendar getCalendar(TimeZone timezone) {
        Calendar calendar;
        if (calendarThreadLocal.get() == null) {
            calendarThreadLocal.set(new HashMap());
        }
        if ((calendar = calendarThreadLocal.get().get(timezone)) == null) {
            calendar = new GregorianCalendar(timezone);
            calendarThreadLocal.get().put(timezone, calendar);
        }
        return calendar;
    }

    public static Calendar getCalendar() {
        return ISO8601DateFormat.getCalendar(TimeZone.getDefault());
    }

    public static String format(Date isoDate) {
        Calendar calendar = ISO8601DateFormat.getCalendar(UTC_TIMEZONE);
        calendar.setTime(isoDate);
        if (calendar.get(1) > 1847) {
            DateTime dt = new DateTime((Object)isoDate, DateTimeZone.UTC);
            return dt.toString();
        }
        int val = 0;
        StringBuilder formatted = new StringBuilder(28);
        formatted.append(calendar.get(1));
        formatted.append('-');
        val = calendar.get(2) + 1;
        formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        formatted.append('-');
        val = calendar.get(5);
        formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        formatted.append('T');
        val = calendar.get(11);
        formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        formatted.append(':');
        val = calendar.get(12);
        formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        formatted.append(':');
        val = calendar.get(13);
        formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        formatted.append('.');
        val = calendar.get(14);
        if (val < 10) {
            formatted.append(val < 10 ? "00" + val : Integer.valueOf(val));
        } else if (val >= 10 && val < 100) {
            formatted.append(val < 10 ? "0" + val : Integer.valueOf(val));
        } else {
            formatted.append(val);
        }
        formatted.append('Z');
        return formatted.toString();
    }

    public static String formatToZulu(String isoDate) {
        try {
            DateTime dt = new DateTime((Object)isoDate, DateTimeZone.UTC);
            return dt.toString();
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }

    public static Date parse(String isoDate) {
        return ISO8601DateFormat.parseInternal(isoDate, null);
    }

    public static Date parse(String isoDate, TimeZone timezone) {
        return ISO8601DateFormat.parseInternal(isoDate, timezone);
    }

    public static Date parseInternal(String isoDate, TimeZone timezone) {
        try {
            DateTimeZone dtz = DateTimeZone.forTimeZone((TimeZone)timezone);
            try {
                GJChronology chrono = GJChronology.getInstance((DateTimeZone)dtz);
                DateTime dateTime = new DateTime((Object)isoDate, (Chronology)chrono);
                Date date = dateTime.toDate();
                return date;
            }
            catch (IllegalInstantException ie) {
                DateTimeFormatter parser = ISODateTimeFormat.dateTimeParser();
                LocalDate ldate = new LocalDate((Object)parser.parseLocalDate(isoDate), dtz);
                DateTime dateT = ldate.toDateTimeAtStartOfDay(dtz);
                Date date = dateT.toDate();
                return date;
            }
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }

    public static boolean isTimeComponentDefined(String isoDate) {
        boolean defined = false;
        if (isoDate != null && isoDate.length() > 11) {
            int expectedLocation = 10;
            if (isoDate.charAt(0) == '-' || isoDate.charAt(0) == '+') {
                ++expectedLocation;
            }
            defined = isoDate.length() >= expectedLocation && isoDate.charAt(expectedLocation) == 'T';
        }
        return defined;
    }

    public static Date parseDayOnly(String isoDate, TimeZone timezone) {
        try {
            if (isoDate != null && isoDate.length() >= 10) {
                int offset = 0;
                boolean bc = false;
                if (isoDate.charAt(0) == '-') {
                    bc = true;
                } else if (isoDate.charAt(0) == '+') {
                    ++offset;
                }
                int year = Integer.parseInt(isoDate.substring(++offset, offset += 4));
                if (isoDate.charAt(offset) != '-') {
                    throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
                }
                int month = Integer.parseInt(isoDate.substring(++offset, offset += 2));
                if (isoDate.charAt(offset) != '-') {
                    throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
                }
                int day = Integer.parseInt(isoDate.substring(++offset, offset += 2));
                GregorianCalendar calendar = new GregorianCalendar(timezone);
                calendar.setLenient(false);
                calendar.set(1, year);
                calendar.set(2, month - 1);
                calendar.set(5, day);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                if (bc) {
                    calendar.set(0, 0);
                }
                return calendar.getTime();
            }
            throw new AlfrescoRuntimeException("String passed is too short " + isoDate);
        }
        catch (IndexOutOfBoundsException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
        catch (NumberFormatException e) {
            throw new AlfrescoRuntimeException("Failed to parse date " + isoDate, e);
        }
    }
}

