/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetProducer;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortedIntDocSet;

public class DocSetUtil {
    public static int smallSetSize(int maxDoc) {
        return (maxDoc >> 6) + 5;
    }

    public static boolean equals(DocSet a, DocSet b) {
        int d2;
        int d1;
        DocIterator iter1 = a.iterator();
        DocIterator iter2 = b.iterator();
        do {
            boolean n2;
            boolean n1;
            if ((n1 = iter1.hasNext()) != (n2 = iter2.hasNext())) {
                return false;
            }
            if (n1) continue;
            return true;
        } while ((d1 = iter1.nextDoc()) == (d2 = iter2.nextDoc()));
        return false;
    }

    public static DocSet getDocSet(DocSetCollector collector, SolrIndexSearcher searcher) {
        if (collector.size() == searcher.numDocs()) {
            if (!searcher.isLiveDocsInstantiated()) {
                searcher.setLiveDocs(collector.getDocSet());
            }
            try {
                return searcher.getLiveDocs();
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return collector.getDocSet();
    }

    public static DocSet getDocSet(DocSet docs, SolrIndexSearcher searcher) {
        if (docs.size() == searcher.numDocs()) {
            if (!searcher.isLiveDocsInstantiated()) {
                searcher.setLiveDocs(docs);
            }
            try {
                return searcher.getLiveDocs();
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return docs;
    }

    public static DocSet createDocSet(SolrIndexSearcher searcher, Query query, DocSet filter) throws IOException {
        DocSet set;
        if (filter != null) {
            Filter luceneFilter = filter.getTopFilter();
            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)luceneFilter, BooleanClause.Occur.FILTER).build();
        }
        if (query instanceof TermQuery) {
            set = DocSetUtil.createDocSet(searcher, ((TermQuery)query).getTerm());
            return set;
        }
        if (query instanceof DocSetProducer) {
            set = ((DocSetProducer)query).createDocSet(searcher);
            return set;
        }
        return DocSetUtil.createDocSetGeneric(searcher, query);
    }

    public static DocSet createDocSetGeneric(SolrIndexSearcher searcher, Query query) throws IOException {
        int maxDoc = searcher.getIndexReader().maxDoc();
        DocSetCollector collector = new DocSetCollector(maxDoc);
        searcher.search(query, (Collector)collector);
        return DocSetUtil.getDocSet(collector, searcher);
    }

    public static DocSet createDocSet(SolrIndexSearcher searcher, Term term) throws IOException {
        DirectoryReader reader = searcher.getRawReader();
        int maxDoc = searcher.getIndexReader().maxDoc();
        int smallSetSize = DocSetUtil.smallSetSize(maxDoc);
        String field = term.field();
        BytesRef termVal = term.bytes();
        int maxCount = 0;
        int firstReader = -1;
        List leaves = reader.leaves();
        PostingsEnum[] postList = new PostingsEnum[leaves.size()];
        for (LeafReaderContext ctx : leaves) {
            TermsEnum te;
            assert (leaves.get(ctx.ord) == ctx);
            LeafReader r = ctx.reader();
            Fields f = r.fields();
            Terms t = f.terms(field);
            if (t == null || !(te = t.iterator()).seekExact(termVal)) continue;
            maxCount += te.docFreq();
            postList[ctx.ord] = te.postings(null, 0);
            if (firstReader >= 0) continue;
            firstReader = ctx.ord;
        }
        DocSet answer = null;
        answer = maxCount == 0 ? DocSet.EMPTY : (maxCount <= smallSetSize ? DocSetUtil.createSmallSet(leaves, postList, maxCount, firstReader) : DocSetUtil.createBigSet(leaves, postList, maxDoc, firstReader));
        return DocSetUtil.getDocSet(answer, searcher);
    }

    private static DocSet createSmallSet(List<LeafReaderContext> leaves, PostingsEnum[] postList, int maxPossible, int firstReader) throws IOException {
        int[] docs = new int[maxPossible];
        int sz = 0;
        for (int i = firstReader; i < postList.length; ++i) {
            int subId;
            PostingsEnum postings = postList[i];
            if (postings == null) continue;
            LeafReaderContext ctx = leaves.get(i);
            Bits liveDocs = ctx.reader().getLiveDocs();
            int base = ctx.docBase;
            while ((subId = postings.nextDoc()) != Integer.MAX_VALUE) {
                if (liveDocs != null && !liveDocs.get(subId)) continue;
                int globalId = subId + base;
                docs[sz++] = globalId;
            }
        }
        return new SortedIntDocSet(docs, sz);
    }

    private static DocSet createBigSet(List<LeafReaderContext> leaves, PostingsEnum[] postList, int maxDoc, int firstReader) throws IOException {
        long[] bits = new long[FixedBitSet.bits2words((int)maxDoc)];
        int sz = 0;
        for (int i = firstReader; i < postList.length; ++i) {
            int subId;
            PostingsEnum postings = postList[i];
            if (postings == null) continue;
            LeafReaderContext ctx = leaves.get(i);
            Bits liveDocs = ctx.reader().getLiveDocs();
            int base = ctx.docBase;
            while ((subId = postings.nextDoc()) != Integer.MAX_VALUE) {
                if (liveDocs != null && !liveDocs.get(subId)) continue;
                int globalId = subId + base;
                int n = globalId >> 6;
                bits[n] = bits[n] | 1L << globalId;
                ++sz;
            }
        }
        BitDocSet docSet = new BitDocSet(new FixedBitSet(bits, maxDoc), sz);
        int smallSetSize = DocSetUtil.smallSetSize(maxDoc);
        if (sz < smallSetSize) {
            DocSet smallSet = DocSetUtil.toSmallSet(docSet);
            return smallSet;
        }
        return docSet;
    }

    public static DocSet toSmallSet(BitDocSet bitSet) {
        int sz = bitSet.size();
        int[] docs = new int[sz];
        FixedBitSet bs = bitSet.getBits();
        int doc = -1;
        for (int i = 0; i < sz; ++i) {
            docs[i] = doc = bs.nextSetBit(doc + 1);
        }
        return new SortedIntDocSet(docs);
    }

    public static void collectSortedDocSet(DocSet docs, IndexReader reader, Collector collector) throws IOException {
        List leaves = reader.leaves();
        Iterator ctxIt = leaves.iterator();
        int segBase = 0;
        int adjustedMax = 0;
        LeafReaderContext ctx = null;
        LeafCollector leafCollector = null;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = (ctx = (LeafReaderContext)ctxIt.next()).reader().maxDoc()))) {
                }
                leafCollector = collector.getLeafCollector(ctx);
            }
            if (doc < segBase) {
                throw new IllegalStateException("algorithm expects sorted DocSet but wasn't: " + docs.getClass());
            }
            leafCollector.collect(doc - segBase);
        }
    }
}

