/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.CommandOperation;

public class CollectionHandlerApi
extends BaseHandlerApiSupport {
    final CollectionsHandler handler;

    public CollectionHandlerApi(CollectionsHandler handler) {
        this.handler = handler;
    }

    @Override
    protected List<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return Arrays.asList(Cmd.values());
    }

    @Override
    protected List<BaseHandlerApiSupport.V2EndPoint> getEndPoints() {
        return Arrays.asList(EndPoint.values());
    }

    static enum EndPoint implements BaseHandlerApiSupport.V2EndPoint
    {
        CLUSTER("cluster"),
        CLUSTER_ALIASES("cluster.aliases"),
        CLUSTER_CMD("cluster.Commands"),
        CLUSTER_NODES("cluster.nodes"),
        CLUSTER_CMD_STATUS("cluster.commandstatus"),
        CLUSTER_CMD_STATUS_DELETE("cluster.commandstatus.delete"),
        COLLECTIONS_COMMANDS("collections.Commands"),
        COLLECTIONS("collections"),
        COLLECTION_STATE("collections.collection"),
        PER_COLLECTION("collections.collection.Commands"),
        PER_COLLECTION_DELETE("collections.collection.delete"),
        PER_COLLECTION_SHARDS_COMMANDS("collections.collection.shards.Commands"),
        PER_COLLECTION_PER_SHARD_COMMANDS("collections.collection.shards.shard.Commands"),
        PER_COLLECTION_PER_SHARD_DELETE("collections.collection.shards.shard.delete"),
        PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE("collections.collection.shards.shard.replica.delete");

        final String specName;

        private EndPoint(String specName) {
            this.specName = specName;
        }

        @Override
        public String getSpecName() {
            return this.specName;
        }
    }

    static enum Cmd implements BaseHandlerApiSupport.ApiCommand
    {
        GET_COLLECTIONS(EndPoint.COLLECTIONS, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.LIST_OP),
        GET_CLUSTER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.LIST_OP, "/cluster", null),
        GET_CLUSTER_OVERSEER(EndPoint.CLUSTER, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.OVERSEERSTATUS_OP, "/cluster/overseer", null),
        GET_CLUSTER_STATUS_CMD(EndPoint.CLUSTER_CMD_STATUS, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.REQUESTSTATUS_OP),
        DELETE_CLUSTER_STATUS(EndPoint.CLUSTER_CMD_STATUS_DELETE, SolrRequest.METHOD.DELETE, CollectionsHandler.CollectionOperation.DELETESTATUS_OP),
        GET_A_COLLECTION(EndPoint.COLLECTION_STATE, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.CLUSTERSTATUS_OP),
        LIST_ALIASES(EndPoint.CLUSTER_ALIASES, SolrRequest.METHOD.GET, CollectionsHandler.CollectionOperation.LISTALIASES_OP),
        CREATE_COLLECTION(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.CREATE_OP, CollectionsHandler.CollectionOperation.CREATE_OP.action.toLower(), (Map<String, String>)ImmutableMap.of((Object)"collection.configName", (Object)"config", (Object)"createNodeSet.shuffle", (Object)"shuffleNodes", (Object)"createNodeSet", (Object)"nodeSet"), (Map<String, String>)ImmutableMap.of((Object)"properties.", (Object)"property.")),
        DELETE_COLL(EndPoint.PER_COLLECTION_DELETE, SolrRequest.METHOD.DELETE, CollectionsHandler.CollectionOperation.DELETE_OP, CollectionsHandler.CollectionOperation.DELETE_OP.action.toLower(), (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"collection")),
        RELOAD_COLL(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.RELOAD_OP, CollectionsHandler.CollectionOperation.RELOAD_OP.action.toLower(), (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"collection")),
        MODIFYCOLLECTION(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.MODIFYCOLLECTION_OP, "modify", null),
        MIGRATE_DOCS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.MIGRATE_OP, "migrate-docs", (Map<String, String>)ImmutableMap.of((Object)"split.key", (Object)"splitKey", (Object)"target.collection", (Object)"target", (Object)"forward.timeout", (Object)"forwardTimeout")),
        REBALANCELEADERS(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.REBALANCELEADERS_OP, "rebalance-leaders", null),
        CREATE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.CREATEALIAS_OP, "create-alias", null),
        DELETE_ALIAS(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.DELETEALIAS_OP, "delete-alias", null),
        CREATE_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.CREATESHARD_OP, "create", (Map)ImmutableMap.of((Object)"createNodeSet", (Object)"nodeSet"), (Map)ImmutableMap.of((Object)"coreProperties.", (Object)"property.")){

            @Override
            public String getParamSubstitute(String param) {
                return super.getParamSubstitute(param);
            }
        }
        ,
        SPLIT_SHARD(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.SPLITSHARD_OP, "split", (Map<String, String>)ImmutableMap.of((Object)"split.key", (Object)"splitKey"), (Map<String, String>)ImmutableMap.of((Object)"coreProperties.", (Object)"property.")),
        DELETE_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_DELETE, SolrRequest.METHOD.DELETE, CollectionsHandler.CollectionOperation.DELETESHARD_OP),
        CREATE_REPLICA(EndPoint.PER_COLLECTION_SHARDS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.ADDREPLICA_OP, "add-replica", null, (Map<String, String>)ImmutableMap.of((Object)"coreProperties.", (Object)"property.")),
        DELETE_REPLICA(EndPoint.PER_COLLECTION_PER_SHARD_PER_REPLICA_DELETE, SolrRequest.METHOD.DELETE, CollectionsHandler.CollectionOperation.DELETEREPLICA_OP),
        SYNC_SHARD(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.SYNCSHARD_OP, "synch-shard", null),
        ADDREPLICAPROP(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.ADDREPLICAPROP_OP, "add-replica-property", (Map<String, String>)ImmutableMap.of((Object)"property", (Object)"name", (Object)"property.value", (Object)"value")),
        DELETEREPLICAPROP(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.DELETEREPLICAPROP_OP, "delete-replica-property", null),
        ADDROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.ADDROLE_OP, "add-role", null),
        REMOVEROLE(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.REMOVEROLE_OP, "remove-role", null),
        CLUSTERPROP(EndPoint.CLUSTER_CMD, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.CLUSTERPROP_OP, "set-property", null),
        BACKUP(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.BACKUP_OP, "backup-collection", null),
        RESTORE(EndPoint.COLLECTIONS_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.RESTORE_OP, "restore-collection", null),
        GET_NODES(EndPoint.CLUSTER_NODES, SolrRequest.METHOD.GET, null){

            @Override
            public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                rsp.add("nodes", ((CollectionHandlerApi)apiHandler).handler.coreContainer.getZkController().getClusterState().getLiveNodes());
            }
        }
        ,
        FORCELEADER(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.FORCELEADER_OP, "force-leader", null),
        SYNCSHARD(EndPoint.PER_COLLECTION_PER_SHARD_COMMANDS, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.SYNCSHARD_OP, "sync-shard", null),
        BALANCESHARDUNIQUE(EndPoint.PER_COLLECTION, SolrRequest.METHOD.POST, CollectionsHandler.CollectionOperation.BALANCESHARDUNIQUE_OP, "balance-shard-unique", null);

        public final String commandName;
        public final EndPoint endPoint;
        public final SolrRequest.METHOD method;
        public final CollectionsHandler.CollectionOperation target;
        public final Map<String, String> paramstoAttr;
        public final Map<String, String> prefixSubstitutes;

        public SolrRequest.METHOD getMethod() {
            return this.method;
        }

        private Cmd(EndPoint endPoint, SolrRequest.METHOD method, CollectionsHandler.CollectionOperation target) {
            this(endPoint, method, target, null, null);
        }

        private Cmd(EndPoint endPoint, SolrRequest.METHOD method, CollectionsHandler.CollectionOperation target, String commandName, Map<String, String> paramstoAttr) {
            this(endPoint, method, target, commandName, paramstoAttr, Collections.EMPTY_MAP);
        }

        private Cmd(EndPoint endPoint, SolrRequest.METHOD method, CollectionsHandler.CollectionOperation target, String commandName, Map<String, String> paramstoAttr, Map<String, String> prefixSubstitutes) {
            this.commandName = commandName;
            this.endPoint = endPoint;
            this.method = method;
            this.target = target;
            this.paramstoAttr = paramstoAttr == null ? Collections.EMPTY_MAP : paramstoAttr;
            this.prefixSubstitutes = prefixSubstitutes;
        }

        @Override
        public String getName() {
            return this.commandName;
        }

        @Override
        public SolrRequest.METHOD getHttpMethod() {
            return this.method;
        }

        @Override
        public BaseHandlerApiSupport.V2EndPoint getEndPoint() {
            return this.endPoint;
        }

        @Override
        public Collection<String> getParamNames(CommandOperation op) {
            Collection<String> paramNames = BaseHandlerApiSupport.getParamNames(op, this);
            if (!this.prefixSubstitutes.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>(paramNames.size());
                for (Map.Entry<String, String> e : this.prefixSubstitutes.entrySet()) {
                    for (String paramName : paramNames) {
                        if (paramName.startsWith(e.getKey())) {
                            result.add(paramName.replace(e.getKey(), e.getValue()));
                            continue;
                        }
                        result.add(paramName);
                    }
                    paramNames = result;
                }
            }
            return paramNames;
        }

        @Override
        public String getParamSubstitute(String param) {
            String s;
            String string = s = this.paramstoAttr.containsKey(param) ? this.paramstoAttr.get(param) : param;
            if (this.prefixSubstitutes != null) {
                for (Map.Entry<String, String> e : this.prefixSubstitutes.entrySet()) {
                    if (!s.startsWith(e.getValue())) continue;
                    return s.replace(e.getValue(), e.getKey());
                }
            }
            return s;
        }

        @Override
        public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
            ((CollectionHandlerApi)apiHandler).handler.invokeAction(req, rsp, ((CollectionHandlerApi)apiHandler).handler.coreContainer, this.target.action, this.target);
        }
    }
}

