/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElectionContext
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final String electionPath;
    final ZkNodeProps leaderProps;
    final String id;
    final String leaderPath;
    volatile String leaderSeqPath;
    private SolrZkClient zkClient;

    public ElectionContext(String coreNodeName, String electionPath, String leaderPath, ZkNodeProps leaderProps, SolrZkClient zkClient) {
        this.id = coreNodeName;
        this.electionPath = electionPath;
        this.leaderPath = leaderPath;
        this.leaderProps = leaderProps;
        this.zkClient = zkClient;
    }

    @Override
    public void close() {
    }

    public void cancelElection() throws InterruptedException, KeeperException {
        if (this.leaderSeqPath != null) {
            try {
                log.debug("Canceling election {}", (Object)this.leaderSeqPath);
                this.zkClient.delete(this.leaderSeqPath, -1, true);
            }
            catch (KeeperException.NoNodeException e) {
                log.debug("cancelElection did not find election node to remove {}", (Object)this.leaderSeqPath);
            }
        } else {
            log.debug("cancelElection skipped as this context has not been initialized");
        }
    }

    abstract void runLeaderProcess(boolean var1, int var2) throws KeeperException, InterruptedException, IOException;

    public void checkIfIamLeaderFired() {
    }

    public void joinedElectionFired() {
    }

    public ElectionContext copy() {
        throw new UnsupportedOperationException("copy");
    }
}

