/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.FileContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.ConfigFileFinder;
import org.alfresco.util.ConfigScheduler;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ShutdownIndicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.quartz.CronExpression;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.element.GenericConfigElement;

public class MimetypeMap
implements MimetypeService {
    public static final String PREFIX_APPLICATION = "application/";
    public static final String PREFIX_AUDIO = "audio/";
    public static final String PREFIX_IMAGE = "image/";
    public static final String PREFIX_MESSAGE = "message/";
    public static final String PREFIX_MODEL = "model/";
    public static final String PREFIX_MULTIPART = "multipart/";
    public static final String PREFIX_TEXT = "text/";
    public static final String PREFIX_VIDEO = "video/";
    public static final String EXTENSION_BINARY = "bin";
    public static final String MACOS_RESOURCE_FORK_FILE_NAME_PREFIX = "._";
    public static final String MIMETYPE_MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_TEXT_MEDIAWIKI = "text/mediawiki";
    public static final String MIMETYPE_TEXT_CSS = "text/css";
    public static final String MIMETYPE_TEXT_CSV = "text/csv";
    public static final String MIMETYPE_TEXT_JAVASCRIPT = "text/javascript";
    public static final String MIMETYPE_XML = "text/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_XHTML = "application/xhtml+xml";
    public static final String MIMETYPE_PDF = "application/pdf";
    public static final String MIMETYPE_JSON = "application/json";
    public static final String MIMETYPE_WORD = "application/msword";
    public static final String MIMETYPE_EXCEL = "application/vnd.ms-excel";
    public static final String MIMETYPE_BINARY = "application/octet-stream";
    public static final String MIMETYPE_PPT = "application/vnd.ms-powerpoint";
    public static final String MIMETYPE_APP_DWG = "application/dwg";
    public static final String MIMETYPE_IMG_DWG = "image/vnd.dwg";
    public static final String MIMETYPE_VIDEO_AVI = "video/x-msvideo";
    public static final String MIMETYPE_VIDEO_QUICKTIME = "video/quicktime";
    public static final String MIMETYPE_VIDEO_WMV = "video/x-ms-wmv";
    public static final String MIMETYPE_VIDEO_3GP = "video/3gpp";
    public static final String MIMETYPE_VIDEO_3GP2 = "video/3gpp2";
    public static final String MIMETYPE_DITA = "application/dita+xml";
    public static final String MIMETYPE_FLASH = "application/x-shockwave-flash";
    public static final String MIMETYPE_VIDEO_FLV = "video/x-flv";
    public static final String MIMETYPE_APPLICATION_FLA = "application/x-fla";
    public static final String MIMETYPE_VIDEO_MPG = "video/mpeg";
    public static final String MIMETYPE_VIDEO_MP4 = "video/mp4";
    public static final String MIMETYPE_IMAGE_GIF = "image/gif";
    public static final String MIMETYPE_IMAGE_JPEG = "image/jpeg";
    public static final String MIMETYPE_IMAGE_RGB = "image/x-rgb";
    public static final String MIMETYPE_IMAGE_SVG = "image/svg+xml";
    public static final String MIMETYPE_IMAGE_PNG = "image/png";
    public static final String MIMETYPE_IMAGE_TIFF = "image/tiff";
    public static final String MIMETYPE_IMAGE_RAW_DNG = "image/x-raw-adobe";
    public static final String MIMETYPE_IMAGE_RAW_3FR = "image/x-raw-hasselblad";
    public static final String MIMETYPE_IMAGE_RAW_RAF = "image/x-raw-fuji";
    public static final String MIMETYPE_IMAGE_RAW_CR2 = "image/x-raw-canon";
    public static final String MIMETYPE_IMAGE_RAW_K25 = "image/x-raw-kodak";
    public static final String MIMETYPE_IMAGE_RAW_MRW = "image/x-raw-minolta";
    public static final String MIMETYPE_IMAGE_RAW_NEF = "image/x-raw-nikon";
    public static final String MIMETYPE_IMAGE_RAW_ORF = "image/x-raw-olympus";
    public static final String MIMETYPE_IMAGE_RAW_PEF = "image/x-raw-pentax";
    public static final String MIMETYPE_IMAGE_RAW_ARW = "image/x-raw-sony";
    public static final String MIMETYPE_IMAGE_RAW_X3F = "image/x-raw-sigma";
    public static final String MIMETYPE_IMAGE_RAW_RW2 = "image/x-raw-panasonic";
    public static final String MIMETYPE_IMAGE_RAW_RWL = "image/x-raw-leica";
    public static final String MIMETYPE_IMAGE_RAW_R3D = "image/x-raw-red";
    public static final String MIMETYPE_IMAGE_DWT = "image/x-dwt";
    public static final String MIMETYPE_IMAGE_ICNS = "image/icns";
    public static final String MIMETYPE_APPLICATION_EPS = "application/eps";
    public static final String MIMETYPE_APPLICATION_PS = "application/postscript";
    public static final String MIMETYPE_JAVASCRIPT = "application/x-javascript";
    public static final String MIMETYPE_ZIP = "application/zip";
    public static final String MIMETYPE_OPENSEARCH_DESCRIPTION = "application/opensearchdescription+xml";
    public static final String MIMETYPE_ATOM = "application/atom+xml";
    public static final String MIMETYPE_RSS = "application/rss+xml";
    public static final String MIMETYPE_RFC822 = "message/rfc822";
    public static final String MIMETYPE_OUTLOOK_MSG = "application/vnd.ms-outlook";
    public static final String MIMETYPE_VISIO = "application/vnd.visio";
    public static final String MIMETYPE_VISIO_2013 = "application/vnd.visio2013";
    public static final String MIMETYPE_APPLICATION_ILLUSTRATOR = "application/illustrator";
    public static final String MIMETYPE_APPLICATION_PHOTOSHOP = "image/vnd.adobe.photoshop";
    public static final String MIMETYPE_ENCRYPTED_OFFICE = "application/x-tika-ooxml-protected";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_TEMPLATE = "application/vnd.oasis.opendocument.text-template";
    public static final String MIMETYPE_OPENDOCUMENT_GRAPHICS = "application/vnd.oasis.opendocument.graphics";
    public static final String MIMETYPE_OPENDOCUMENT_GRAPHICS_TEMPLATE = "application/vnd.oasis.opendocument.graphics-template";
    public static final String MIMETYPE_OPENDOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
    public static final String MIMETYPE_OPENDOCUMENT_PRESENTATION_TEMPLATE = "application/vnd.oasis.opendocument.presentation-template";
    public static final String MIMETYPE_OPENDOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    public static final String MIMETYPE_OPENDOCUMENT_SPREADSHEET_TEMPLATE = "application/vnd.oasis.opendocument.spreadsheet-template";
    public static final String MIMETYPE_OPENDOCUMENT_CHART = "application/vnd.oasis.opendocument.chart";
    public static final String MIMETYPE_OPENDOCUMENT_CHART_TEMPLATE = "applicationvnd.oasis.opendocument.chart-template";
    public static final String MIMETYPE_OPENDOCUMENT_IMAGE = "application/vnd.oasis.opendocument.image";
    public static final String MIMETYPE_OPENDOCUMENT_IMAGE_TEMPLATE = "applicationvnd.oasis.opendocument.image-template";
    public static final String MIMETYPE_OPENDOCUMENT_FORMULA = "application/vnd.oasis.opendocument.formula";
    public static final String MIMETYPE_OPENDOCUMENT_FORMULA_TEMPLATE = "applicationvnd.oasis.opendocument.formula-template";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_MASTER = "application/vnd.oasis.opendocument.text-master";
    public static final String MIMETYPE_OPENDOCUMENT_TEXT_WEB = "application/vnd.oasis.opendocument.text-web";
    public static final String MIMETYPE_OPENDOCUMENT_DATABASE = "application/vnd.oasis.opendocument.database";
    public static final String MIMETYPE_OPENOFFICE1_WRITER = "application/vnd.sun.xml.writer";
    public static final String MIMETYPE_OPENOFFICE1_CALC = "application/vnd.sun.xml.calc";
    public static final String MIMETYPE_OPENOFFICE1_DRAW = "application/vnd.sun.xml.draw";
    public static final String MIMETYPE_OPENOFFICE1_IMPRESS = "application/vnd.sun.xml.impress";
    public static final String MIMETYPE_OPENXML_WORDPROCESSING = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String MIMETYPE_OPENXML_WORDPROCESSING_MACRO = "application/vnd.ms-word.document.macroenabled.12";
    public static final String MIMETYPE_OPENXML_WORD_TEMPLATE = "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
    public static final String MIMETYPE_OPENXML_WORD_TEMPLATE_MACRO = "application/vnd.ms-word.template.macroenabled.12";
    public static final String MIMETYPE_OPENXML_SPREADSHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String MIMETYPE_OPENXML_SPREADSHEET_TEMPLATE = "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
    public static final String MIMETYPE_OPENXML_SPREADSHEET_MACRO = "application/vnd.ms-excel.sheet.macroenabled.12";
    public static final String MIMETYPE_OPENXML_SPREADSHEET_TEMPLATE_MACRO = "application/vnd.ms-excel.template.macroenabled.12";
    public static final String MIMETYPE_OPENXML_SPREADSHEET_ADDIN_MACRO = "application/vnd.ms-excel.addin.macroenabled.12";
    public static final String MIMETYPE_OPENXML_SPREADSHEET_BINARY_MACRO = "application/vnd.ms-excel.sheet.binary.macroenabled.12";
    public static final String MIMETYPE_OPENXML_PRESENTATION = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String MIMETYPE_OPENXML_PRESENTATION_MACRO = "application/vnd.ms-powerpoint.presentation.macroenabled.12";
    public static final String MIMETYPE_OPENXML_PRESENTATION_SLIDESHOW = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
    public static final String MIMETYPE_OPENXML_PRESENTATION_SLIDESHOW_MACRO = "application/vnd.ms-powerpoint.slideshow.macroenabled.12";
    public static final String MIMETYPE_OPENXML_PRESENTATION_TEMPLATE = "application/vnd.openxmlformats-officedocument.presentationml.template";
    public static final String MIMETYPE_OPENXML_PRESENTATION_TEMPLATE_MACRO = "application/vnd.ms-powerpoint.template.macroenabled.12";
    public static final String MIMETYPE_OPENXML_PRESENTATION_ADDIN = "application/vnd.ms-powerpoint.addin.macroenabled.12";
    public static final String MIMETYPE_OPENXML_PRESENTATION_SLIDE = "application/vnd.openxmlformats-officedocument.presentationml.slide";
    public static final String MIMETYPE_OPENXML_PRESENTATION_SLIDE_MACRO = "application/vnd.ms-powerpoint.slide.macroenabled.12";
    public static final String MIMETYPE_STAROFFICE5_DRAW = "application/vnd.stardivision.draw";
    public static final String MIMETYPE_STAROFFICE5_CALC = "application/vnd.stardivision.calc";
    public static final String MIMETYPE_STAROFFICE5_IMPRESS = "application/vnd.stardivision.impress";
    public static final String MIMETYPE_STAROFFICE5_IMPRESS_PACKED = "application/vnd.stardivision.impress-packed";
    public static final String MIMETYPE_STAROFFICE5_CHART = "application/vnd.stardivision.chart";
    public static final String MIMETYPE_STAROFFICE5_WRITER = "application/vnd.stardivision.writer";
    public static final String MIMETYPE_STAROFFICE5_WRITER_GLOBAL = "application/vnd.stardivision.writer-global";
    public static final String MIMETYPE_STAROFFICE5_MATH = "application/vnd.stardivision.math";
    public static final String MIMETYPE_IWORK_KEYNOTE = "application/vnd.apple.keynote";
    public static final String MIMETYPE_IWORK_NUMBERS = "application/vnd.apple.numbers";
    public static final String MIMETYPE_IWORK_PAGES = "application/vnd.apple.pages";
    public static final String MIMETYPE_APPLEFILE = "application/applefile";
    public static final String MIMETYPE_WORDPERFECT = "application/wordperfect";
    public static final String MIMETYPE_MP3 = "audio/mpeg";
    public static final String MIMETYPE_AUDIO_MP4 = "audio/mp4";
    public static final String MIMETYPE_VORBIS = "audio/vorbis";
    public static final String MIMETYPE_FLAC = "audio/x-flac";
    public static final String MIMETYPE_ACP = "application/acp";
    private static final String CONFIG_AREA = "mimetype-map";
    private static final String CONFIG_CONDITION = "Mimetype Map";
    private static final String ELEMENT_MIMETYPES = "mimetypes";
    private static final String ATTR_MIMETYPE = "mimetype";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_EXTENSION = "extension";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_TEXT = "text";
    private static final Log logger = LogFactory.getLog(MimetypeMap.class);
    private ConfigService configService;
    private ContentCharsetFinder contentCharsetFinder;
    private TikaConfig tikaConfig;
    private Detector detector;
    private ObjectMapper jsonObjectMapper;
    private String mimetypeJsonConfigDir;
    private CronExpression cronExpression;
    private CronExpression initialAndOnErrorCronExpression;
    private ConfigScheduler<Data> configScheduler = new ConfigScheduler(this){

        @Override
        public boolean readConfig() throws IOException {
            if (MimetypeMap.this.jsonConfigFileFinder != null) {
                MimetypeMap.this.jsonConfigFileFinder.setFileCount(0);
            }
            return MimetypeMap.this.readConfig();
        }

        public Object createData() {
            return MimetypeMap.this.createData();
        }
    };
    private ConfigFileFinder jsonConfigFileFinder;

    public Data createData() {
        return new Data();
    }

    public Data getData() {
        return this.configScheduler.getData();
    }

    public MimetypeMap() {
    }

    @Deprecated
    public MimetypeMap(ConfigService configService) {
        logger.warn((Object)"MimetypeMap(ConfigService configService) has been deprecated.  Use the default constructor and property 'configService'");
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public ContentCharsetFinder getContentCharsetFinder() {
        return this.contentCharsetFinder;
    }

    public void setContentCharsetFinder(ContentCharsetFinder contentCharsetFinder) {
        this.contentCharsetFinder = contentCharsetFinder;
    }

    public void setTikaConfig(TikaConfig tikaConfig) {
        this.tikaConfig = tikaConfig;
    }

    public void setJsonObjectMapper(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public void setMimetypeJsonConfigDir(String mimetypeJsonConfigDir) {
        this.mimetypeJsonConfigDir = mimetypeJsonConfigDir;
    }

    public void setCronExpression(CronExpression cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setInitialAndOnErrorCronExpression(CronExpression initialAndOnErrorCronExpression) {
        this.initialAndOnErrorCronExpression = initialAndOnErrorCronExpression;
    }

    public void setShutdownIndicator(ShutdownIndicator shutdownIndicator) {
        this.configScheduler.setShutdownIndicator(shutdownIndicator);
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"configService", (Object)this.configService);
        PropertyCheck.mandatory((Object)this, (String)"contentCharsetFinder", (Object)this.contentCharsetFinder);
        if (this.mimetypeJsonConfigDir != null || this.jsonObjectMapper != null || this.cronExpression != null || this.initialAndOnErrorCronExpression != null) {
            PropertyCheck.mandatory((Object)this, (String)"jsonObjectMapper", (Object)this.jsonObjectMapper);
            if (this.cronExpression != null) {
                PropertyCheck.mandatory((Object)this, (String)"initialAndOnErrorCronExpression", (Object)this.initialAndOnErrorCronExpression);
            }
            this.jsonConfigFileFinder = new ConfigFileFinder(this.jsonObjectMapper){

                @Override
                protected void readJson(JsonNode jsonNode, String readFromMessage, String baseUrl) throws IOException {
                    try {
                        JsonNode mediaTypes = jsonNode.get("mediaTypes");
                        if (mediaTypes != null && mediaTypes.isArray()) {
                            ArrayList<ConfigElement> mimetypes = new ArrayList<ConfigElement>();
                            for (JsonNode mediaType : mediaTypes) {
                                MediaTypeDef def = (MediaTypeDef)MimetypeMap.this.jsonObjectMapper.convertValue((Object)mediaType, MediaTypeDef.class);
                                GenericConfigElement mimetype = new GenericConfigElement(MimetypeMap.ATTR_MIMETYPE);
                                mimetype.addAttribute(MimetypeMap.ATTR_DISPLAY, def.name);
                                mimetype.addAttribute(MimetypeMap.ATTR_MIMETYPE, def.mediaType);
                                if (def.text) {
                                    mimetype.addAttribute(MimetypeMap.ATTR_TEXT, Boolean.TRUE.toString());
                                }
                                GenericConfigElement ext = null;
                                int count = 0;
                                for (ExtensionDef extension : def.extensions) {
                                    ext = new GenericConfigElement(MimetypeMap.ATTR_EXTENSION);
                                    ext.setValue(extension.extension);
                                    if (extension.name != null && !extension.name.isBlank()) {
                                        ext.addAttribute(MimetypeMap.ATTR_DISPLAY, extension.name);
                                    }
                                    if (extension.isDefault) {
                                        ext.addAttribute(MimetypeMap.ATTR_DEFAULT, Boolean.TRUE.toString());
                                    }
                                    mimetype.addChild((ConfigElement)ext);
                                    ++count;
                                }
                                if (count == 1 && ext.getAttribute(MimetypeMap.ATTR_DEFAULT) == null) {
                                    ext.addAttribute(MimetypeMap.ATTR_DEFAULT, Boolean.TRUE.toString());
                                }
                                mimetypes.add((ConfigElement)mimetype);
                            }
                            MimetypeMap.this.registerMimetypes(mimetypes);
                            Data data = MimetypeMap.this.getData();
                            ++data.fileCount;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)("Error reading " + readFromMessage + " " + e.getMessage()));
                    }
                }
            };
        }
        if (this.tikaConfig == null) {
            logger.warn((Object)"TikaConfig spring parameter not supplied, using default config");
            this.setTikaConfig(TikaConfig.getDefaultConfig());
        }
        this.detector = new DefaultDetector(this.tikaConfig.getMimeRepository());
        this.configScheduler.run(true, logger, this.cronExpression, this.initialAndOnErrorCronExpression);
    }

    public boolean readConfig() {
        Config config = this.configService.getConfig((Object)CONFIG_CONDITION, new ConfigLookupContext(CONFIG_AREA));
        ConfigElement mimetypesElement = config.getConfigElement(ELEMENT_MIMETYPES);
        List mimetypes = mimetypesElement.getChildren();
        this.registerMimetypes(mimetypes);
        Data data = this.getData();
        data.xmlCount = mimetypes.size();
        boolean successReadingConfig = true;
        if (this.jsonConfigFileFinder != null) {
            successReadingConfig &= this.jsonConfigFileFinder.readFiles("alfresco/mimetypes", logger);
            if (this.mimetypeJsonConfigDir != null && !this.mimetypeJsonConfigDir.isBlank()) {
                successReadingConfig &= this.jsonConfigFileFinder.readFiles(this.mimetypeJsonConfigDir, logger);
            }
        }
        data.makeCollectionsReadOnly();
        return successReadingConfig;
    }

    private void registerMimetypes(List<ConfigElement> mimetypes) {
        int count = 0;
        Data data = this.getData();
        for (ConfigElement mimetypeElement : mimetypes) {
            boolean prevIsText;
            String isTextStr;
            boolean isText;
            String mimetypeDisplay;
            ++count;
            String mimetype = mimetypeElement.getAttribute(ATTR_MIMETYPE);
            if (mimetype == null || mimetype.length() == 0) {
                logger.warn((Object)("Ignoring empty mimetype " + count));
                continue;
            }
            boolean replacement = data.mimetypes.contains(mimetype = mimetype.toLowerCase());
            if (!replacement) {
                data.mimetypes.add(mimetype);
            }
            if ((mimetypeDisplay = mimetypeElement.getAttribute(ATTR_DISPLAY)) != null && mimetypeDisplay.length() > 0) {
                String prev = data.displaysByMimetype.put(mimetype, mimetypeDisplay);
                if (replacement && prev != null && !mimetypeDisplay.equals(prev)) {
                    logger.warn((Object)("Replacing " + mimetype + " display value '" + prev + "' with '" + mimetypeDisplay + "'"));
                }
            }
            boolean bl = isText = Boolean.parseBoolean(isTextStr = mimetypeElement.getAttribute(ATTR_TEXT)) || mimetype.startsWith(PREFIX_TEXT);
            boolean bl2 = replacement ? data.textMimetypes.contains(mimetype) : (prevIsText = !isText);
            if (isText != prevIsText) {
                if (isText) {
                    data.textMimetypes.add(mimetype);
                } else if (replacement) {
                    data.textMimetypes.remove(mimetype);
                }
                if (replacement) {
                    logger.warn((Object)("Replacing " + mimetype + " text value " + (prevIsText ? "'true' with 'false'" : "'false' with 'true'")));
                }
            }
            List extensions = mimetypeElement.getChildren();
            for (ConfigElement extensionElement : extensions) {
                String extension = extensionElement.getValue();
                if (extension == null || extension.length() == 0) {
                    logger.warn((Object)("Ignoring empty extension for mimetype: " + mimetype));
                    continue;
                }
                extension = extension.toLowerCase();
                data.mimetypesByExtension.put(extension, mimetype);
                String extensionDisplay = extensionElement.getAttribute(ATTR_DISPLAY);
                String prev = data.displaysByExtension.get(extension);
                if (prev == null && (extensionDisplay == null || extensionDisplay.length() == 0) && mimetypeDisplay != null && mimetypeDisplay.length() > 0) {
                    extensionDisplay = mimetypeDisplay;
                }
                if (extensionDisplay != null) {
                    data.displaysByExtension.put(extension, extensionDisplay);
                    if (prev != null && !extensionDisplay.equals(prev)) {
                        logger.warn((Object)("Replacing " + mimetype + " extension display value '" + prev + "' with '" + extensionDisplay + "'"));
                    }
                }
                String prevExtension = data.extensionsByMimetype.get(mimetype);
                String isDefaultStr = extensionElement.getAttribute(ATTR_DEFAULT);
                boolean isDefault = Boolean.parseBoolean(isDefaultStr) || prevExtension == null;
                if (!isDefault) continue;
                data.extensionsByMimetype.put(mimetype, extension);
                if (prevExtension == null || extension.equals(prevExtension)) continue;
                logger.warn((Object)("Replacing " + mimetype + " default extension '" + prevExtension + "' with '" + extension + "'"));
            }
            if (extensions.size() != 0) continue;
            logger.warn((Object)("No extensions defined for mimetype: " + mimetype));
        }
    }

    @Override
    public String getExtension(String mimetype) {
        Data data = this.getData();
        String extension = data.extensionsByMimetype.get(mimetype);
        return extension == null ? EXTENSION_BINARY : extension;
    }

    @Override
    public String getMimetype(String extension) {
        return this.getMimetype(extension, MIMETYPE_BINARY);
    }

    private String getMimetype(String extension, String defaultMimetype) {
        String mimetype = null;
        if (extension != null) {
            extension = extension.toLowerCase();
            Data data = this.getData();
            if (data.mimetypesByExtension.containsKey(extension)) {
                mimetype = data.mimetypesByExtension.get(extension);
            }
        }
        return mimetype == null ? defaultMimetype : mimetype;
    }

    @Override
    public Map<String, String> getDisplaysByExtension() {
        Data data = this.getData();
        return data.displaysByExtension;
    }

    @Override
    public Map<String, String> getDisplaysByMimetype() {
        Data data = this.getData();
        return data.displaysByMimetype;
    }

    @Override
    public Map<String, String> getExtensionsByMimetype() {
        Data data = this.getData();
        return data.extensionsByMimetype;
    }

    @Override
    public List<String> getMimetypes() {
        Data data = this.getData();
        return data.mimetypes;
    }

    @Override
    public Map<String, String> getMimetypesByExtension() {
        Data data = this.getData();
        return data.mimetypesByExtension;
    }

    @Override
    public boolean isText(String mimetype) {
        Data data = this.getData();
        return data.textMimetypes.contains(mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaType detectType(String filename, ContentReader reader) {
        TikaInputStream inp = null;
        try {
            if (reader != null) {
                if (reader instanceof FileContentReader) {
                    try {
                        inp = TikaInputStream.get((File)((FileContentReader)reader).getFile());
                    }
                    catch (FileNotFoundException e) {
                        logger.warn((Object)("No backing file found for ContentReader " + e));
                        MediaType mediaType = null;
                        if (inp != null) {
                            try {
                                inp.close();
                            }
                            catch (IOException e2) {
                                logger.error((Object)"Error while closing TikaInputStream.", (Throwable)e2);
                            }
                        }
                        return mediaType;
                    }
                }
                inp = TikaInputStream.get((InputStream)reader.getContentInputStream());
            }
            MediaType mediaType = this.detectType(filename, inp);
            return mediaType;
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error while closing TikaInputStream.", (Throwable)e);
                }
            }
        }
    }

    private MediaType detectType(String filename, InputStream input) {
        TikaInputStream inp = null;
        if (input != null) {
            inp = TikaInputStream.get((InputStream)input);
        }
        return this.detectType(filename, inp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaType detectType(String filename, TikaInputStream input) {
        MediaType type;
        Metadata metadata = new Metadata();
        if (filename != null) {
            metadata.add("resourceName", filename);
        }
        TikaInputStream inp = null;
        if (input != null) {
            inp = TikaInputStream.get((InputStream)input);
        }
        try {
            type = this.detector.detect((InputStream)inp, metadata);
            type = this.typeBasedOnDetectedTypeAndExtension(type, filename);
            logger.debug((Object)(input + " detected by Tika as being " + type.toString()));
        }
        catch (Exception e) {
            logger.warn((Object)"Error identifying content type of problem document", (Throwable)e);
            MediaType mediaType = null;
            return mediaType;
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception exception) {}
            }
        }
        return type;
    }

    private MediaType typeBasedOnDetectedTypeAndExtension(MediaType type, String filename) {
        if (filename != null && type != null) {
            String[] detectedAndPossibleTypes = new String[]{MIMETYPE_PDF, MIMETYPE_APPLICATION_ILLUSTRATOR, MIMETYPE_APPLICATION_PS, MIMETYPE_APPLICATION_EPS};
            for (int i = detectedAndPossibleTypes.length - 1; i >= 0; i -= 2) {
                String possibleType;
                String extension;
                String detectedType = detectedAndPossibleTypes[i - 1];
                if (!detectedType.equals(type.toString()) || !filename.endsWith("." + (extension = this.getExtension(possibleType = detectedAndPossibleTypes[i])))) continue;
                type = MediaType.parse((String)possibleType);
                break;
            }
        }
        return type;
    }

    @Override
    public String getMimetypeIfNotMatches(ContentReader reader) {
        MediaType type = this.detectType(null, reader);
        if (type == null) {
            return null;
        }
        if (type.toString().equals(reader.getMimetype())) {
            return null;
        }
        MediaType claimed = MediaType.parse((String)reader.getMimetype());
        if (this.tikaConfig.getMediaTypeRegistry().isSpecializationOf(claimed, type) || this.tikaConfig.getMediaTypeRegistry().isSpecializationOf(type, claimed)) {
            return null;
        }
        SortedSet aliases = this.tikaConfig.getMediaTypeRegistry().getAliases(type);
        for (MediaType alias : aliases) {
            String aliasType = alias.toString();
            if (!aliasType.equals(claimed.toString())) continue;
            return null;
        }
        return type.toString();
    }

    @Override
    public String guessMimetype(String filename) {
        int index;
        String mimetype = MIMETYPE_BINARY;
        if (filename != null && filename.length() > 0 && (index = filename.lastIndexOf(46)) > -1 && index < filename.length() - 1) {
            String extension = filename.substring(index + 1).toLowerCase();
            Data data = this.getData();
            if (data.mimetypesByExtension.containsKey(extension)) {
                mimetype = data.mimetypesByExtension.get(extension);
            }
        }
        return mimetype;
    }

    @Override
    public String guessMimetype(String filename, ContentReader reader) {
        if (reader != null && reader.getMimetype() != null && !reader.getMimetype().equals(MIMETYPE_BINARY)) {
            return reader.getMimetype();
        }
        InputStream input = reader != null ? reader.getContentInputStream() : null;
        return this.guessMimetype(filename, input);
    }

    @Override
    public String guessMimetype(String filename, InputStream input) {
        MediaType type = this.detectType(filename, input);
        String filenameGuess = this.guessMimetype(filename);
        if (type == null || MediaType.OCTET_STREAM.equals((Object)type) || MIMETYPE_ENCRYPTED_OFFICE.equals(type.toString())) {
            return filenameGuess;
        }
        if ((MediaType.TEXT_PLAIN.equals((Object)type) || MediaType.APPLICATION_XML.equals((Object)type)) && !filenameGuess.equals(MIMETYPE_BINARY)) {
            return filenameGuess;
        }
        if (type.hasParameters()) {
            type = type.getBaseType();
        }
        String tikaType = type.toString();
        Data data = this.getData();
        if (data.mimetypes.contains(tikaType)) {
            return tikaType;
        }
        SortedSet aliases = this.tikaConfig.getMediaTypeRegistry().getAliases(type);
        for (MediaType alias : aliases) {
            String aliasType = alias.toString();
            if (!data.mimetypes.contains(aliasType)) continue;
            return aliasType;
        }
        logger.info((Object)("Tika detected a type of " + tikaType + " for file " + filename + " which Alfresco doesn't know about. Consider  adding that type to your configuration"));
        return tikaType;
    }

    @Override
    public Collection<String> getMimetypes(String extension) {
        Collection<String> sourceMimetypes;
        if (extension == null) {
            sourceMimetypes = this.getMimetypes();
            sourceMimetypes = this.sortMimetypesByExt(sourceMimetypes);
        } else {
            String mimetype = this.getMimetype(extension, null);
            sourceMimetypes = mimetype == null ? Collections.emptySet() : Collections.singleton(mimetype);
        }
        return sourceMimetypes;
    }

    private Collection<String> sortMimetypesByExt(Collection<String> mimetypes) {
        int i;
        ArrayList<String> result = new ArrayList<String>(mimetypes);
        for (i = result.size() - 1; i >= 0; --i) {
            result.set(i, this.getExtension((String)result.get(i)));
        }
        Collections.sort(result);
        for (i = result.size() - 1; i >= 0; --i) {
            result.set(i, this.getMimetype((String)result.get(i)));
        }
        return result;
    }

    static class Data {
        private List<String> mimetypes = new ArrayList<String>(40);
        private Map<String, String> extensionsByMimetype = new HashMap<String, String>(59);
        private Map<String, String> mimetypesByExtension = new HashMap<String, String>(59);
        private Map<String, String> displaysByMimetype = new TreeMap<String, String>();
        private Map<String, String> displaysByExtension = new HashMap<String, String>(59);
        private Set<String> textMimetypes = new HashSet<String>(23);
        private int xmlCount;
        private int fileCount;

        Data() {
        }

        private void makeCollectionsReadOnly() {
            this.mimetypes = Collections.unmodifiableList(this.mimetypes);
            this.extensionsByMimetype = Collections.unmodifiableMap(this.extensionsByMimetype);
            this.mimetypesByExtension = Collections.unmodifiableMap(this.mimetypesByExtension);
            this.displaysByMimetype = Collections.unmodifiableMap(this.displaysByMimetype);
            this.displaysByExtension = Collections.unmodifiableMap(this.displaysByExtension);
        }

        public String toString() {
            int mimetypeCount = this.mimetypes.size();
            return "(mimetypes: " + mimetypeCount + " from XML: " + this.xmlCount + " from JSON: " + (mimetypeCount - this.xmlCount) + " files: " + this.fileCount + ")";
        }
    }

    private static class ExtensionDef {
        private String extension;
        private String name;
        private boolean isDefault;

        private ExtensionDef() {
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDefault(boolean theDefault) {
            this.isDefault = theDefault;
        }
    }

    private static class MediaTypeDef {
        private String name;
        private String mediaType;
        private boolean text;
        private ExtensionDef[] extensions;

        private MediaTypeDef() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public void setText(boolean text) {
            this.text = text;
        }

        public void setExtensions(ExtensionDef[] extensions) {
            this.extensions = extensions;
        }
    }
}

