/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueBool;
import org.apache.solr.search.function.OrdFieldSource;

class BoolFieldSource
extends ValueSource {
    protected String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public BoolFieldSource(String field) {
        this.field = field;
    }

    public String description() {
        return "bool(" + this.field + ')';
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final SortedDocValues sindex = DocValues.getSorted((LeafReader)readerContext.reader(), (String)this.field);
        int nord = sindex.getValueCount();
        int tord = -2;
        for (int i = 0; i < nord; ++i) {
            BytesRef br = sindex.lookupOrd(i);
            if (br.length != 1 || br.bytes[br.offset] != 84) continue;
            tord = i;
            break;
        }
        final int trueOrd = tord;
        return new BoolDocValues(this){

            public boolean boolVal(int doc) {
                return sindex.getOrd(doc) == trueOrd;
            }

            public boolean exists(int doc) {
                return sindex.getOrd(doc) != -1;
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueBool mval = new MutableValueBool();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        int ord = sindex.getOrd(doc);
                        this.mval.value = ord == trueOrd;
                        this.mval.exists = ord != -1;
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        return o.getClass() == BoolFieldSource.class && this.field.equals(((BoolFieldSource)((Object)o)).field);
    }

    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

