/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCoreMetricManager
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore core;
    private final SolrMetricManager metricManager;
    private String registryName;

    public SolrCoreMetricManager(SolrCore core) {
        this.core = core;
        this.metricManager = core.getCoreContainer().getMetricManager();
        this.registryName = SolrCoreMetricManager.createRegistryName(core.getCoreDescriptor().getCollectionName(), core.getName());
    }

    public void loadReporters() {
        NodeConfig nodeConfig = this.core.getCoreContainer().getConfig();
        PluginInfo[] pluginInfos = nodeConfig.getMetricReporterPlugins();
        this.metricManager.loadReporters(pluginInfos, this.core.getResourceLoader(), SolrInfoMBean.Group.core, this.registryName);
    }

    public void afterCoreSetName() {
        String oldRegistryName = this.registryName;
        this.registryName = SolrCoreMetricManager.createRegistryName(this.core.getCoreDescriptor().getCollectionName(), this.core.getName());
        if (oldRegistryName.equals(this.registryName)) {
            return;
        }
        this.metricManager.closeReporters(oldRegistryName);
        this.loadReporters();
    }

    public void registerMetricProducer(String scope, SolrMetricProducer producer) {
        if (scope == null || producer == null) {
            throw new IllegalArgumentException("registerMetricProducer() called with illegal arguments: scope = " + scope + ", producer = " + producer);
        }
        producer.initializeMetrics(this.metricManager, this.getRegistryName(), scope);
    }

    @Override
    public void close() throws IOException {
        this.metricManager.closeReporters(this.getRegistryName());
    }

    public SolrCore getCore() {
        return this.core;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public static String createRegistryName(String collectionName, String coreName) {
        String shard;
        if (collectionName == null || collectionName != null && !coreName.startsWith(collectionName + "_")) {
            return SolrMetricManager.getRegistryName(SolrInfoMBean.Group.core, coreName);
        }
        String str = coreName.substring(collectionName.length() + 1);
        String replica = null;
        int pos = str.lastIndexOf("_replica");
        if (pos == -1) {
            shard = str;
        } else {
            shard = str.substring(0, pos);
            replica = str.substring(pos + 1);
        }
        return SolrMetricManager.getRegistryName(SolrInfoMBean.Group.core, collectionName, shard, replica);
    }
}

