/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.AddReplicaCmd;
import org.apache.solr.cloud.BackupCmd;
import org.apache.solr.cloud.CreateAliasCmd;
import org.apache.solr.cloud.CreateCollectionCmd;
import org.apache.solr.cloud.CreateShardCmd;
import org.apache.solr.cloud.CreateSnapshotCmd;
import org.apache.solr.cloud.DeleteAliasCmd;
import org.apache.solr.cloud.DeleteCollectionCmd;
import org.apache.solr.cloud.DeleteNodeCmd;
import org.apache.solr.cloud.DeleteReplicaCmd;
import org.apache.solr.cloud.DeleteShardCmd;
import org.apache.solr.cloud.DeleteSnapshotCmd;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LockTree;
import org.apache.solr.cloud.MigrateCmd;
import org.apache.solr.cloud.MoveReplicaCmd;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerRoleCmd;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerStatusCmd;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.ReplaceNodeCmd;
import org.apache.solr.cloud.RestoreCmd;
import org.apache.solr.cloud.SplitShardCmd;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionMessageHandler
implements OverseerMessageHandler,
Closeable {
    public static final String NUM_SLICES = "numShards";
    static final boolean CREATE_NODE_SET_SHUFFLE_DEFAULT = true;
    public static final String CREATE_NODE_SET_SHUFFLE = "createNodeSet.shuffle";
    public static final String CREATE_NODE_SET_EMPTY = "EMPTY";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String REQUESTID = "requestid";
    public static final String COLL_CONF = "collection.configName";
    public static final String COLL_PROP_PREFIX = "property.";
    public static final String ONLY_IF_DOWN = "onlyIfDown";
    public static final String SHARD_UNIQUE = "shardUnique";
    public static final String ONLY_ACTIVE_NODES = "onlyactivenodes";
    static final String SKIP_CREATE_REPLICA_IN_CLUSTER_STATE = "skipCreateReplicaInClusterState";
    public static final Map<String, Object> COLL_PROPS = Collections.unmodifiableMap(Utils.makeMap((Object[])new Object[]{"router", "compositeId", "replicationFactor", "1", "maxShardsPerNode", "1", "autoAddReplicas", "false", "rule", null, "snitch", null}));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Overseer overseer;
    ShardHandlerFactory shardHandlerFactory;
    String adminPath;
    ZkStateReader zkStateReader;
    String myId;
    Overseer.Stats stats;
    private final LockTree lockTree = new LockTree();
    ExecutorService tpe = new ExecutorUtil.MDCAwareThreadPoolExecutor(5, 10, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("OverseerCollectionMessageHandlerThreadFactory"));
    static final Random RANDOM;
    final Map<CollectionParams.CollectionAction, Cmd> commandMap;
    private long sessionId = -1L;
    private LockTree.Session lockSession;

    public OverseerCollectionMessageHandler(ZkStateReader zkStateReader, String myId, ShardHandlerFactory shardHandlerFactory, String adminPath, Overseer.Stats stats, Overseer overseer, OverseerNodePrioritizer overseerPrioritizer) {
        this.zkStateReader = zkStateReader;
        this.shardHandlerFactory = shardHandlerFactory;
        this.adminPath = adminPath;
        this.myId = myId;
        this.stats = stats;
        this.overseer = overseer;
        this.commandMap = new ImmutableMap.Builder().put((Object)CollectionParams.CollectionAction.REPLACENODE, (Object)new ReplaceNodeCmd(this)).put((Object)CollectionParams.CollectionAction.DELETENODE, (Object)new DeleteNodeCmd(this)).put((Object)CollectionParams.CollectionAction.BACKUP, (Object)new BackupCmd(this)).put((Object)CollectionParams.CollectionAction.RESTORE, (Object)new RestoreCmd(this)).put((Object)CollectionParams.CollectionAction.CREATESNAPSHOT, (Object)new CreateSnapshotCmd(this)).put((Object)CollectionParams.CollectionAction.DELETESNAPSHOT, (Object)new DeleteSnapshotCmd(this)).put((Object)CollectionParams.CollectionAction.SPLITSHARD, (Object)new SplitShardCmd(this)).put((Object)CollectionParams.CollectionAction.ADDROLE, (Object)new OverseerRoleCmd(this, CollectionParams.CollectionAction.ADDROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.REMOVEROLE, (Object)new OverseerRoleCmd(this, CollectionParams.CollectionAction.REMOVEROLE, overseerPrioritizer)).put((Object)CollectionParams.CollectionAction.MOCK_COLL_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MOCK_SHARD_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MOCK_REPLICA_TASK, this::mockOperation).put((Object)CollectionParams.CollectionAction.MIGRATESTATEFORMAT, this::migrateStateFormat).put((Object)CollectionParams.CollectionAction.CREATESHARD, (Object)new CreateShardCmd(this)).put((Object)CollectionParams.CollectionAction.MIGRATE, (Object)new MigrateCmd(this)).put((Object)CollectionParams.CollectionAction.CREATE, (Object)new CreateCollectionCmd(this)).put((Object)CollectionParams.CollectionAction.MODIFYCOLLECTION, this::modifyCollection).put((Object)CollectionParams.CollectionAction.ADDREPLICAPROP, this::processReplicaAddPropertyCommand).put((Object)CollectionParams.CollectionAction.DELETEREPLICAPROP, this::processReplicaDeletePropertyCommand).put((Object)CollectionParams.CollectionAction.BALANCESHARDUNIQUE, this::balanceProperty).put((Object)CollectionParams.CollectionAction.REBALANCELEADERS, this::processRebalanceLeaders).put((Object)CollectionParams.CollectionAction.RELOAD, this::reloadCollection).put((Object)CollectionParams.CollectionAction.DELETE, (Object)new DeleteCollectionCmd(this)).put((Object)CollectionParams.CollectionAction.CREATEALIAS, (Object)new CreateAliasCmd(this)).put((Object)CollectionParams.CollectionAction.DELETEALIAS, (Object)new DeleteAliasCmd(this)).put((Object)CollectionParams.CollectionAction.OVERSEERSTATUS, (Object)new OverseerStatusCmd(this)).put((Object)CollectionParams.CollectionAction.DELETESHARD, (Object)new DeleteShardCmd(this)).put((Object)CollectionParams.CollectionAction.DELETEREPLICA, (Object)new DeleteReplicaCmd(this)).put((Object)CollectionParams.CollectionAction.ADDREPLICA, (Object)new AddReplicaCmd(this)).put((Object)CollectionParams.CollectionAction.MOVEREPLICA, (Object)new MoveReplicaCmd(this)).build();
    }

    @Override
    public SolrResponse processMessage(ZkNodeProps message, String operation) {
        log.debug("OverseerCollectionMessageHandler.processMessage : " + operation + " , " + message.toString());
        NamedList results = new NamedList();
        try {
            CollectionParams.CollectionAction action = this.getCollectionAction(operation);
            Cmd command = this.commandMap.get(action);
            if (command == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            command.call(this.zkStateReader.getClusterState(), message, results);
        }
        catch (Exception e) {
            String collName = message.getStr("collection");
            if (collName == null) {
                collName = message.getStr("name");
            }
            if (collName == null) {
                SolrException.log((Logger)log, (String)("Operation " + operation + " failed"), (Throwable)e);
            } else {
                SolrException.log((Logger)log, (String)("Collection: " + collName + " operation: " + operation + " failed"), (Throwable)e);
            }
            results.add("Operation " + operation + " caused exception:", (Object)e);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)e.getMessage());
            nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
            results.add("exception", (Object)nl);
        }
        return new OverseerSolrResponse(results);
    }

    @SuppressForbidden(reason="Needs currentTimeMillis for mock requests")
    private void mockOperation(ClusterState state, ZkNodeProps message, NamedList results) throws InterruptedException {
        Thread.sleep(message.getInt("sleep", Integer.valueOf(1)).intValue());
        log.info("MOCK_TASK_EXECUTED time {} data {}", (Object)System.currentTimeMillis(), (Object)Utils.toJSONString((Object)message));
        results.add("MOCK_FINISHED", (Object)System.currentTimeMillis());
    }

    private CollectionParams.CollectionAction getCollectionAction(String operation) {
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)operation);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
        }
        return action;
    }

    private void reloadCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
        String asyncId = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (asyncId != null) {
            requestMap = new HashMap<String, String>();
        }
        this.collectionCmd(message, params, results, Replica.State.ACTIVE, asyncId, requestMap);
    }

    private void processRebalanceLeaders(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.checkRequired(message, "collection", "shard", "core", "election_node", "core_node_name", "base_url", "rejoinAtHead");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("collection", new String[]{message.getStr("collection")});
        params.set("shard", new String[]{message.getStr("shard")});
        params.set("rejoinAtHead", new String[]{message.getStr("rejoinAtHead")});
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.toString()});
        params.set("core", new String[]{message.getStr("core")});
        params.set("core_node_name", new String[]{message.getStr("core_node_name")});
        params.set("election_node", new String[]{message.getStr("election_node")});
        params.set("base_url", new String[]{message.getStr("base_url")});
        String baseUrl = message.getStr("base_url");
        ShardRequest sreq = new ShardRequest();
        sreq.nodeName = message.getStr("core");
        params.set("qt", new String[]{this.adminPath});
        sreq.purpose = 1;
        sreq.shards = new String[]{baseUrl};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        shardHandler.submit(sreq, baseUrl, sreq.params);
    }

    private void processReplicaAddPropertyCommand(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        this.checkRequired(message, "collection", "shard", "replica", "property", "property.value");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getStateUpdateQueue(zkClient);
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        inQueue.offer(Utils.toJSON((Object)m));
    }

    private void processReplicaDeletePropertyCommand(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica", "property");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getStateUpdateQueue(zkClient);
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        inQueue.offer(Utils.toJSON((Object)m));
    }

    private void balanceProperty(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)message.getStr("collection")) || StringUtils.isBlank((CharSequence)message.getStr("property"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'collection' and 'property' parameters are required for the BALANCESHARDUNIQUE operation, no action taken");
        }
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getStateUpdateQueue(zkClient);
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        propMap.putAll(message.getProperties());
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(propMap)));
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry next : collectionProps) {
            Map collMap = (Map)next.getValue();
            Map shards = (Map)collMap.get(SHARDS_PROP);
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if (Replica.State.getState((String)((String)replicaMap.get("state"))) == Replica.State.DOWN || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", Replica.State.DOWN.toString());
                }
            }
        }
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return collection;
        }
        Map shards = (Map)collection.get(SHARDS_PROP);
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put(SHARDS_PROP, selected);
        }
        return collection;
    }

    void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws Exception {
        ((DeleteReplicaCmd)this.commandMap.get(CollectionParams.CollectionAction.DELETEREPLICA)).deleteReplica(clusterState, message, results, onComplete);
    }

    boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms) throws InterruptedException {
        TimeOut timeout = new TimeOut(timeoutms, TimeUnit.MILLISECONDS);
        boolean deleted = false;
        while (!timeout.hasTimedOut()) {
            Slice slice;
            Thread.sleep(100L);
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (docCollection != null && ((slice = docCollection.getSlice(shard)) == null || slice.getReplica(replicaName) == null)) {
                deleted = true;
            }
            if (docCollection != null && !deleted) continue;
            break;
        }
        return deleted;
    }

    void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", OverseerAction.DELETECORE.toLower(), "core", core, "node_name", replica.getStr("node_name"), "collection", collectionName, "core_node_name", replicaName, "base_url", replica.getStr("base_url")});
        Overseer.getStateUpdateQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON((Object)m));
    }

    void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), (char)',') + " are required params");
        }
    }

    private void migrateStateFormat(ClusterState state, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("collection");
        boolean firstLoop = true;
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        while (!timeout.hasTimedOut()) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " not found");
            }
            if (collection.getStateFormat() == 2) {
                results.add("success", (Object)new SimpleOrderedMap());
                return;
            }
            if (firstLoop) {
                firstLoop = false;
                ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MIGRATESTATEFORMAT.toLower(), "collection", collectionName});
                Overseer.getStateUpdateQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON((Object)m));
            }
            Thread.sleep(100L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not migrate state format for collection: " + collectionName);
    }

    void commit(NamedList results, String slice, Replica parentShardLeader) {
        log.debug("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps((ZkNodeProps)parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = OverseerCollectionMessageHandler.softCommit(coreUrl);
            this.processResponse(results, null, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
        }
        catch (Exception e) {
            this.processResponse(results, e, coreUrl, (SolrResponse)updateResponse, slice, Collections.emptySet());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        try (HttpSolrClient client = new HttpSolrClient.Builder(url).build();){
            client.setConnectionTimeout(30000);
            client.setSoTimeout(120000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = (UpdateResponse)ureq.process((SolrClient)client);
            return updateResponse;
        }
    }

    String waitForCoreNodeName(String collectionName, String msgNodeName, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            Map slicesMap = this.zkStateReader.getClusterState().getSlicesMap(collectionName);
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    void waitForNewShard(String collectionName, String sliceName) throws KeeperException, InterruptedException {
        log.debug("Waiting for slice {} of collection {} to be available", (Object)sliceName, (Object)collectionName);
        RTimer timer = new RTimer();
        int retryCount = 320;
        while (retryCount-- > 0) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find collection: " + collectionName + " in clusterstate");
            }
            Slice slice = collection.getSlice(sliceName);
            if (slice != null) {
                log.debug("Waited for {}ms for slice {} of collection {} to be available", new Object[]{timer.getTime(), sliceName, collectionName});
                return;
            }
            Thread.sleep(1000L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find new slice " + sliceName + " in collection " + collectionName + " even after waiting for " + timer.getTime() + "ms");
    }

    DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }

    void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap) {
        OverseerCollectionMessageHandler.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap, this.adminPath, this.zkStateReader);
    }

    public static void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap, String adminPath, ZkStateReader zkStateReader) {
        if (asyncId != null) {
            String coreAdminAsyncId = asyncId + Math.abs(System.nanoTime());
            params.set("async", new String[]{coreAdminAsyncId});
            requestMap.put(nodeName, coreAdminAsyncId);
        }
        ShardRequest sreq = new ShardRequest();
        params.set("qt", new String[]{adminPath});
        sreq.purpose = 1;
        String replica = zkStateReader.getBaseUrlForNodeName(nodeName);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.nodeName = nodeName;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
    }

    void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            params.set(key, new String[]{message.getStr(key)});
        }
    }

    void addPropertyParams(ZkNodeProps message, Map<String, Object> map) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            map.put(key, message.getStr(key));
        }
    }

    static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random) {
        ArrayList<Object> nodeList;
        List createNodeList;
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        List list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart((String)(CREATE_NODE_SET_EMPTY.equals(createNodeSetStr) ? "" : createNodeSetStr), (String)",", (boolean)true));
        if (createNodeList != null) {
            nodeList = new ArrayList(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool(CREATE_NODE_SET_SHUFFLE, true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(liveNodes);
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    private void modifyCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("collection");
        String configName = (String)message.getProperties().remove(COLL_CONF);
        if (configName != null) {
            this.validateConfigOrThrowSolrException(configName);
            boolean isLegacyCloud = Overseer.isLegacy(this.zkStateReader);
            this.createConfNode(configName, collectionName, isLegacyCloud);
            this.reloadCollection(null, new ZkNodeProps(new String[]{"name", collectionName}), results);
        }
        Overseer.getStateUpdateQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean areChangesVisible = true;
        while (!timeout.hasTimedOut()) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            areChangesVisible = true;
            for (Map.Entry updateEntry : message.getProperties().entrySet()) {
                String updateKey = (String)updateEntry.getKey();
                if (updateKey.equals("collection") || updateKey.equals("operation") || collection.get(updateKey).equals(updateEntry.getValue())) continue;
                areChangesVisible = false;
                break;
            }
            if (areChangesVisible) break;
            Thread.sleep(100L);
        }
        if (!areChangesVisible) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not modify collection " + message);
        }
    }

    void cleanupCollection(String collectionName, NamedList results) throws Exception {
        log.error("Cleaning up collection [" + collectionName + "].");
        Map props = Utils.makeMap((Object[])new Object[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collectionName});
        this.commandMap.get(CollectionParams.CollectionAction.DELETE).call(this.zkStateReader.getClusterState(), new ZkNodeProps(props), results);
    }

    Map<ReplicaAssigner.Position, String> identifyNodes(ClusterState clusterState, List<String> nodeList, ZkNodeProps message, List<String> shardNames, int repFactor) throws IOException {
        List rulesMap = (List)message.get("rule");
        if (rulesMap == null) {
            int i = 0;
            HashMap<ReplicaAssigner.Position, String> result = new HashMap<ReplicaAssigner.Position, String>();
            for (String aShard : shardNames) {
                for (int j = 0; j < repFactor; ++j) {
                    result.put(new ReplicaAssigner.Position(aShard, j), nodeList.get(i % nodeList.size()));
                    ++i;
                }
            }
            return result;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object map : rulesMap) {
            rules.add(new Rule((Map)map));
        }
        HashMap<String, Integer> sharVsReplicaCount = new HashMap<String, Integer>();
        for (String shard : shardNames) {
            sharVsReplicaCount.put(shard, repFactor);
        }
        ReplicaAssigner replicaAssigner = new ReplicaAssigner(rules, sharVsReplicaCount, (List)message.get("snitch"), new HashMap<String, Map<String, Integer>>(), nodeList, this.overseer.getZkController().getCoreContainer(), clusterState);
        return replicaAssigner.getNodeMappings();
    }

    Map<String, Replica> waitToSeeReplicasInState(String collectionName, Collection<String> coreNames) throws InterruptedException {
        HashMap<String, Replica> result = new HashMap<String, Replica>();
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        while (true) {
            DocCollection coll = this.zkStateReader.getClusterState().getCollection(collectionName);
            for (String coreName : coreNames) {
                if (result.containsKey(coreName)) continue;
                block2: for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        if (!coreName.equals(replica.getStr("core"))) continue;
                        result.put(coreName, replica);
                        continue block2;
                    }
                }
            }
            if (result.size() == coreNames.size()) {
                return result;
            }
            if (timeout.hasTimedOut()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out waiting to see all replicas: " + coreNames + " in cluster state.");
            }
            Thread.sleep(100L);
        }
    }

    ZkNodeProps addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results, Runnable onComplete) throws KeeperException, InterruptedException {
        return ((AddReplicaCmd)this.commandMap.get(CollectionParams.CollectionAction.ADDREPLICA)).addReplica(clusterState, message, results, onComplete);
    }

    void processResponses(NamedList results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, String asyncId, Map<String, String> requestMap) {
        this.processResponses(results, shardHandler, abortOnError, msgOnError, asyncId, requestMap, Collections.emptySet());
    }

    void processResponses(NamedList results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, String asyncId, Map<String, String> requestMap, Set<String> okayExceptions) {
        ShardResponse srsp;
        do {
            if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp, okayExceptions);
            Throwable exception = srsp.getException();
            if (!abortOnError || exception == null) continue;
            while (srsp != null) {
                srsp = shardHandler.takeCompletedOrError();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
        } while (srsp != null);
        if (asyncId != null) {
            this.waitForAsyncCallsToComplete(requestMap, results);
            requestMap.clear();
        }
    }

    void validateConfigOrThrowSolrException(String configName) throws KeeperException, InterruptedException {
        boolean isValid = this.zkStateReader.getZkClient().exists("/configs/" + configName, true);
        if (!isValid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find the specified config set: " + configName);
        }
    }

    void createConfNode(String configName, String coll, boolean isLegacyCloud) throws KeeperException, InterruptedException {
        if (configName != null) {
            String collDir = "/collections/" + coll;
            log.debug("creating collections conf node {} ", (Object)collDir);
            byte[] data = Utils.toJSON((Object)Utils.makeMap((Object[])new Object[]{"configName", configName}));
            if (this.zkStateReader.getZkClient().exists(collDir, true).booleanValue()) {
                this.zkStateReader.getZkClient().setData(collDir, data, true);
            } else {
                this.zkStateReader.getZkClient().makePath(collDir, data, true);
            }
        } else if (isLegacyCloud) {
            log.warn("Could not obtain config name");
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to get config name");
        }
    }

    private void collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList results, Replica.State stateMatcher, String asyncId, Map<String, String> requestMap) {
        this.collectionCmd(message, params, results, stateMatcher, asyncId, requestMap, Collections.emptySet());
    }

    void collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList results, Replica.State stateMatcher, String asyncId, Map<String, String> requestMap, Set<String> okayExceptions) {
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollection(collectionName);
        for (Slice slice : coll.getSlices()) {
            this.sliceCmd(clusterState, params, stateMatcher, slice, shardHandler, asyncId, requestMap);
        }
        this.processResponses(results, shardHandler, false, null, asyncId, requestMap, okayExceptions);
    }

    void sliceCmd(ClusterState clusterState, ModifiableSolrParams params, Replica.State stateMatcher, Slice slice, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap) {
        for (Replica replica : slice.getReplicas()) {
            if (!clusterState.liveNodesContain(replica.getStr("node_name")) || stateMatcher != null && Replica.State.getState((String)replica.getStr("state")) != stateMatcher) continue;
            ModifiableSolrParams cloneParams = new ModifiableSolrParams();
            cloneParams.add((SolrParams)params);
            cloneParams.set("core", new String[]{replica.getStr("core")});
            this.sendShardRequest(replica.getStr("node_name"), cloneParams, shardHandler, asyncId, requestMap);
        }
    }

    private void processResponse(NamedList results, ShardResponse srsp, Set<String> okayExceptions) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard, okayExceptions);
    }

    private void processResponse(NamedList results, Throwable e, String nodeName, SolrResponse solrResponse, String shard, Set<String> okayExceptions) {
        String rootThrowable = null;
        if (e instanceof HttpSolrClient.RemoteSolrException) {
            rootThrowable = ((HttpSolrClient.RemoteSolrException)e).getRootThrowable();
        }
        if (!(e == null || rootThrowable != null && okayExceptions.contains(rootThrowable))) {
            log.error("Error from shard: " + shard, e);
            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap();
                results.add("failure", (Object)failure);
            }
            failure.add(nodeName, (Object)(e.getClass().getName() + ":" + e.getMessage()));
        } else {
            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap();
                results.add("success", (Object)success);
            }
            success.add(nodeName, (Object)solrResponse.getResponse());
        }
    }

    private void waitForAsyncCallsToComplete(Map<String, String> requestMap, NamedList results) {
        for (String k : requestMap.keySet()) {
            log.debug("I am Waiting for :{}/{}", (Object)k, (Object)requestMap.get(k));
            results.add(requestMap.get(k), (Object)this.waitForCoreAdminAsyncCallToComplete(k, requestMap.get(k)));
        }
    }

    private NamedList waitForCoreAdminAsyncCallToComplete(String nodeName, String requestId) {
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTSTATUS.toString()});
        params.set(REQUESTID, new String[]{requestId});
        int counter = 0;
        block4: while (true) {
            ShardResponse srsp;
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                NamedList results = new NamedList();
                this.processResponse(results, srsp, Collections.emptySet());
                if (srsp.getSolrResponse().getResponse() == null) {
                    NamedList response = new NamedList();
                    response.add("STATUS", (Object)"failed");
                    return response;
                }
                String r = (String)srsp.getSolrResponse().getResponse().get("STATUS");
                if (r.equals("running")) {
                    log.debug("The task is still RUNNING, continuing to wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (r.equals("completed")) {
                    log.debug("The task is COMPLETED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("failed")) {
                    log.debug("The task is FAILED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("notfound")) {
                    log.debug("The task is notfound, retry");
                    if (counter++ < 5) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block4;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request for requestId: " + requestId + "" + srsp.getSolrResponse().getResponse().get("STATUS") + "retried " + counter + "times");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request " + srsp.getSolrResponse().getResponse().get("STATUS"));
            } while (srsp != null);
        }
    }

    @Override
    public String getName() {
        return "Overseer Collection Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "collection_" + operation;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
    }

    @Override
    public OverseerMessageHandler.Lock lockTask(ZkNodeProps message, OverseerTaskProcessor.TaskBatch taskBatch) {
        if (this.lockSession == null || this.sessionId != taskBatch.getId()) {
            if (taskBatch.getRunningTasks() == 0) {
                this.lockTree.clear();
            }
            this.lockSession = this.lockTree.getSession();
        }
        return this.lockSession.lock(this.getCollectionAction(message.getStr("operation")), Arrays.asList(this.getTaskKey(message), message.getStr("shard"), message.getStr("replica")));
    }

    @Override
    public void close() throws IOException {
        if (this.tpe != null && !this.tpe.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.tpe);
        }
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }

    static interface Cmd {
        public void call(ClusterState var1, ZkNodeProps var2, NamedList var3) throws Exception;
    }
}

