/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeMetadata;
import org.carrot2.util.attribute.BindableDescriptorUtils;
import org.carrot2.util.attribute.CommonMetadata;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;

@Root(name="component-metadata")
public class BindableMetadata
extends CommonMetadata {
    @ElementMap(name="attributes", entry="attribute", key="field-name", inline=false, attribute=true)
    private Map<String, AttributeMetadata> attributeMetadataInternal;

    public Map<String, AttributeMetadata> getAttributeMetadata() {
        return Collections.unmodifiableMap(this.attributeMetadataInternal);
    }

    public void setAttributeMetadata(Map<String, AttributeMetadata> map) {
        this.attributeMetadataInternal = map;
    }

    public String toString() {
        return "[" + this.title + ", " + this.label + ", " + this.description + "]";
    }

    public static BindableMetadata forClassWithParents(Class<?> clazz) {
        IBindableDescriptor descriptor = BindableDescriptorUtils.getDescriptor(clazz);
        BindableMetadata bindable = new BindableMetadata();
        bindable.setDescription(descriptor.getDescription());
        bindable.setLabel(descriptor.getLabel());
        bindable.setTitle(descriptor.getTitle());
        bindable.setAttributeMetadata(BindableMetadata.asAttributeMetadata(descriptor.getAttributes()));
        return bindable;
    }

    private static Map<String, AttributeMetadata> asAttributeMetadata(Set<AttributeInfo> attributes) {
        HashMap<String, AttributeMetadata> map = new HashMap<String, AttributeMetadata>();
        for (AttributeInfo attr : attributes) {
            map.put(attr.fieldName, new AttributeMetadata(attr.title, attr.label, attr.description, attr.group, attr.level));
        }
        return map;
    }
}

