/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

public class BoundedDeque<T>
implements Iterable<T> {
    private LinkedBlockingDeque<T> deque;
    private int max = 10;

    public BoundedDeque(int max) {
        this.max = max;
        this.deque = new LinkedBlockingDeque();
    }

    public int size() {
        return this.deque.size();
    }

    public void add(T add) {
        while (this.deque.size() > this.max - 1) {
            this.deque.removeLast();
        }
        this.deque.addFirst(add);
    }

    public T getLast() {
        return this.deque.getFirst();
    }

    @Override
    public Iterator<T> iterator() {
        return this.deque.iterator();
    }

    public LinkedBlockingDeque<T> getDeque() {
        return new LinkedBlockingDeque<T>(this.deque);
    }

    public void setDeque(LinkedBlockingDeque<T> deque) {
        this.deque = new LinkedBlockingDeque<T>(deque);
    }
}

