/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.AlfrescoKeyStoreImpl;
import org.alfresco.encryption.EncryptionUtils;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.ssl.AuthSSLProtocolSocketFactory;
import org.alfresco.encryption.ssl.SSLEncryptionParameters;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AbstractHttpClient;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.HttpMethodResponse;
import org.alfresco.httpclient.MD5EncryptionParameters;
import org.alfresco.httpclient.Request;
import org.alfresco.httpclient.RequestHeadersHttpClient;
import org.alfresco.httpclient.Response;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientFactory {
    private static final Log logger = LogFactory.getLog(HttpClientFactory.class);
    private SSLEncryptionParameters sslEncryptionParameters;
    private KeyResourceLoader keyResourceLoader;
    private SecureCommsType secureCommsType;
    private KeyStoreParameters keyStoreParameters;
    private MD5EncryptionParameters encryptionParameters;
    private String host;
    private int port;
    private int sslPort;
    private AlfrescoKeyStore sslKeyStore;
    private AlfrescoKeyStore sslTrustStore;
    private ProtocolSocketFactory sslSocketFactory;
    private int maxTotalConnections = 40;
    private int maxHostConnections = 40;
    private Integer socketTimeout = null;
    private int connectionTimeout = 0;
    private String sharedSecret;
    private String sharedSecretHeader = "X-Alfresco-Search-Secret";
    public static final String DEFAULT_SHAREDSECRET_HEADER = "X-Alfresco-Search-Secret";

    public HttpClientFactory() {
    }

    public HttpClientFactory(SecureCommsType secureCommsType, SSLEncryptionParameters sslEncryptionParameters, KeyResourceLoader keyResourceLoader, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters, String host, int port, int sslPort, int maxTotalConnections, int maxHostConnections, int socketTimeout) {
        this.secureCommsType = secureCommsType;
        this.sslEncryptionParameters = sslEncryptionParameters;
        this.keyResourceLoader = keyResourceLoader;
        this.keyStoreParameters = keyStoreParameters;
        this.encryptionParameters = encryptionParameters;
        this.host = host;
        this.port = port;
        this.sslPort = sslPort;
        this.maxTotalConnections = maxTotalConnections;
        this.maxHostConnections = maxHostConnections;
        this.socketTimeout = socketTimeout;
        this.init();
    }

    public HttpClientFactory(SecureCommsType secureCommsType, SSLEncryptionParameters sslEncryptionParameters, KeyResourceLoader keyResourceLoader, KeyStoreParameters keyStoreParameters, MD5EncryptionParameters encryptionParameters, String sharedSecret, String sharedSecretHeader, String host, int port, int sslPort, int maxTotalConnections, int maxHostConnections, int socketTimeout) {
        this(secureCommsType, sslEncryptionParameters, keyResourceLoader, keyStoreParameters, encryptionParameters, host, port, sslPort, maxTotalConnections, maxHostConnections, socketTimeout);
        this.sharedSecret = sharedSecret;
        this.sharedSecretHeader = sharedSecretHeader;
    }

    public void init() {
        this.sslKeyStore = new AlfrescoKeyStoreImpl(this.sslEncryptionParameters.getKeyStoreParameters(), this.keyResourceLoader);
        this.sslTrustStore = new AlfrescoKeyStoreImpl(this.sslEncryptionParameters.getTrustStoreParameters(), this.keyResourceLoader);
        this.sslSocketFactory = new AuthSSLProtocolSocketFactory(this.sslKeyStore, this.sslTrustStore, this.keyResourceLoader);
        DefaultHttpParams.setHttpParamsFactory((HttpParamsFactory)new NonBlockingHttpParamsFactory());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public boolean isSSL() {
        return this.secureCommsType == SecureCommsType.HTTPS;
    }

    public void setSecureCommsType(String type) {
        try {
            this.secureCommsType = SecureCommsType.getType(type);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("", e);
        }
    }

    public void setSSLEncryptionParameters(SSLEncryptionParameters sslEncryptionParameters) {
        this.sslEncryptionParameters = sslEncryptionParameters;
    }

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
    }

    public void setEncryptionParameters(MD5EncryptionParameters encryptionParameters) {
        this.encryptionParameters = encryptionParameters;
    }

    public void setKeyResourceLoader(KeyResourceLoader keyResourceLoader) {
        this.keyResourceLoader = keyResourceLoader;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getMaxHostConnections() {
        return this.maxHostConnections;
    }

    public void setMaxHostConnections(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecretHeader(String sharedSecretHeader) {
        this.sharedSecretHeader = sharedSecretHeader;
    }

    public String getSharedSecretHeader() {
        return this.sharedSecretHeader;
    }

    protected RequestHeadersHttpClient constructHttpClient() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        RequestHeadersHttpClient httpClient = new RequestHeadersHttpClient(connectionManager);
        HttpClientParams params = httpClient.getParams();
        params.setBooleanParameter("http.tcp.nodelay", true);
        params.setBooleanParameter("http.connection.stalecheck", true);
        if (this.socketTimeout != null) {
            params.setSoTimeout(this.socketTimeout.intValue());
        }
        HttpConnectionManagerParams connectionManagerParams = httpClient.getHttpConnectionManager().getParams();
        connectionManagerParams.setMaxTotalConnections(this.maxTotalConnections);
        connectionManagerParams.setDefaultMaxConnectionsPerHost(this.maxHostConnections);
        connectionManagerParams.setConnectionTimeout(this.connectionTimeout);
        return httpClient;
    }

    protected RequestHeadersHttpClient getHttpsClient() {
        return this.getHttpsClient(this.host, this.sslPort);
    }

    protected RequestHeadersHttpClient getHttpsClient(String httpsHost, int httpsPort) {
        RequestHeadersHttpClient httpClient = this.constructHttpClient();
        HttpHostFactory hostFactory = new HttpHostFactory(new Protocol("https", this.sslSocketFactory, 443));
        httpClient.setHostConfiguration(new HostConfigurationWithHostFactory(hostFactory));
        httpClient.getHostConfiguration().setHost(httpsHost, httpsPort, "https");
        return httpClient;
    }

    protected RequestHeadersHttpClient getDefaultHttpClient() {
        return this.getDefaultHttpClient(this.host, this.port);
    }

    protected RequestHeadersHttpClient getDefaultHttpClient(String httpHost, int httpPort) {
        RequestHeadersHttpClient httpClient = this.constructHttpClient();
        httpClient.getHostConfiguration().setHost(httpHost, httpPort);
        return httpClient;
    }

    protected RequestHeadersHttpClient constructSharedSecretHttpClient() {
        RequestHeadersHttpClient client = this.constructHttpClient();
        client.setDefaultHeaders(Map.of(this.sharedSecretHeader, this.sharedSecret));
        return client;
    }

    protected RequestHeadersHttpClient getSharedSecretHttpClient() {
        return this.getSharedSecretHttpClient(this.host, this.port);
    }

    protected RequestHeadersHttpClient getSharedSecretHttpClient(String httpHost, int httpPort) {
        RequestHeadersHttpClient httpClient = this.constructSharedSecretHttpClient();
        httpClient.getHostConfiguration().setHost(httpHost, httpPort);
        return httpClient;
    }

    protected AlfrescoHttpClient getAlfrescoHttpsClient() {
        return new HttpsClient(this.getHttpsClient());
    }

    protected AlfrescoHttpClient getAlfrescoHttpClient() {
        return new DefaultHttpClient(this.getDefaultHttpClient());
    }

    protected AlfrescoHttpClient getAlfrescoSharedSecretClient() {
        return new DefaultHttpClient(this.getSharedSecretHttpClient());
    }

    protected HttpClient getMD5HttpClient(String host, int port) {
        RequestHeadersHttpClient httpClient = this.constructHttpClient();
        httpClient.getHostConfiguration().setHost(host, port);
        return httpClient;
    }

    public AlfrescoHttpClient getRepoClient(String host, int port) {
        switch (this.secureCommsType) {
            case HTTPS: {
                return this.getAlfrescoHttpsClient();
            }
            case NONE: {
                return this.getAlfrescoHttpClient();
            }
            case SECRET: {
                return this.getAlfrescoSharedSecretClient();
            }
        }
        throw new AlfrescoRuntimeException("Invalid Solr secure communications type configured in [solr|alfresco].secureComms, should be 'ssl', 'none' or 'secret'");
    }

    public RequestHeadersHttpClient getHttpClient() {
        switch (this.secureCommsType) {
            case HTTPS: {
                return this.getHttpsClient();
            }
            case NONE: {
                return this.getDefaultHttpClient();
            }
            case SECRET: {
                return this.getSharedSecretHttpClient();
            }
        }
        throw new AlfrescoRuntimeException("Invalid Solr secure communications type configured in [solr|alfresco].secureComms, should be 'ssl', 'none' or 'secret'");
    }

    public RequestHeadersHttpClient getHttpClient(String host, int port) {
        switch (this.secureCommsType) {
            case HTTPS: {
                return this.getHttpsClient(host, port);
            }
            case NONE: {
                return this.getDefaultHttpClient(host, port);
            }
            case SECRET: {
                return this.getSharedSecretHttpClient(host, port);
            }
        }
        throw new AlfrescoRuntimeException("Invalid Solr secure communications type configured in [solr|alfresco].secureComms, should be 'ssl', 'none' or 'secret'");
    }

    public static enum SecureCommsType {
        HTTPS,
        NONE,
        SECRET;


        public static SecureCommsType getType(String type) {
            switch (type.toLowerCase()) {
                case "https": {
                    return HTTPS;
                }
                case "none": {
                    return NONE;
                }
                case "secret": {
                    return SECRET;
                }
            }
            throw new IllegalArgumentException("Invalid communications type");
        }
    }

    public static class NonBlockingHttpParamsFactory
    extends DefaultHttpParamsFactory {
        private volatile HttpParams httpParams;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpParams getDefaultParams() {
            if (this.httpParams == null) {
                NonBlockingHttpParamsFactory nonBlockingHttpParamsFactory = this;
                synchronized (nonBlockingHttpParamsFactory) {
                    if (this.httpParams == null) {
                        this.httpParams = this.createParams();
                    }
                }
            }
            return this.httpParams;
        }

        protected HttpParams createParams() {
            NonBlockingHttpParams params = new NonBlockingHttpParams(null);
            params.setParameter("http.useragent", "Spring Surf via Apache HttpClient/3.1");
            params.setVersion(HttpVersion.HTTP_1_1);
            params.setConnectionManagerClass(SimpleHttpConnectionManager.class);
            params.setCookiePolicy("ignoreCookies");
            params.setHttpElementCharset("US-ASCII");
            params.setContentCharset("ISO-8859-1");
            params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
            List<String> datePatterns = Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z");
            params.setParameter("http.dateparser.patterns", datePatterns);
            String agent = null;
            try {
                agent = System.getProperty("httpclient.useragent");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (agent != null) {
                params.setParameter("http.useragent", agent);
            }
            String preemptiveDefault = null;
            try {
                preemptiveDefault = System.getProperty("httpclient.authentication.preemptive");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (preemptiveDefault != null) {
                if ((preemptiveDefault = preemptiveDefault.trim().toLowerCase()).equals("true")) {
                    params.setParameter("http.authentication.preemptive", Boolean.TRUE);
                } else if (preemptiveDefault.equals("false")) {
                    params.setParameter("http.authentication.preemptive", Boolean.FALSE);
                }
            }
            String defaultCookiePolicy = null;
            try {
                defaultCookiePolicy = System.getProperty("apache.commons.httpclient.cookiespec");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (defaultCookiePolicy != null) {
                if ("COMPATIBILITY".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("compatibility");
                } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("netscape");
                } else if ("RFC2109".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("rfc2109");
                }
            }
            return params;
        }
    }

    private static class HttpHostFactory {
        private Map<String, Protocol> protocols = new HashMap<String, Protocol>(2);

        public HttpHostFactory(Protocol httpsProtocol) {
            this.protocols.put("https", httpsProtocol);
        }

        public HttpHost getHost(String host, int port, String scheme) {
            Protocol protocol;
            if (scheme == null) {
                scheme = "http";
            }
            if ((protocol = this.protocols.get(scheme)) == null && (protocol = Protocol.getProtocol((String)"http")) == null) {
                throw new IllegalArgumentException("Unrecognised scheme parameter");
            }
            return new HttpHost(host, port, protocol);
        }
    }

    private static class HostConfigurationWithHostFactory
    extends HostConfiguration {
        private final HttpHostFactory factory;

        public HostConfigurationWithHostFactory(HttpHostFactory factory) {
            this.factory = factory;
        }

        public synchronized void setHost(String host, int port, String scheme) {
            this.setHost(this.factory.getHost(host, port, scheme));
        }

        public synchronized void setHost(String host, int port) {
            this.setHost(this.factory.getHost(host, port, "http"));
        }

        public synchronized void setHost(URI uri) {
            try {
                this.setHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            catch (URIException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    class HttpsClient
    extends AbstractHttpClient {
        public HttpsClient(HttpClient httpClient) {
            super(httpClient);
        }

        @Override
        public Response sendRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            return new HttpMethodResponse(method);
        }
    }

    class DefaultHttpClient
    extends AbstractHttpClient {
        public DefaultHttpClient(HttpClient httpClient) {
            super(httpClient);
        }

        @Override
        public Response sendRequest(Request req) throws AuthenticationException, IOException {
            HttpMethod method = super.sendRemoteRequest(req);
            return new HttpMethodResponse(method);
        }
    }

    public static class NonBlockingHttpParams
    extends HttpClientParams {
        private HashMap<String, Object> parameters = new HashMap(8);
        private ReadWriteLock paramLock = new ReentrantReadWriteLock();

        public NonBlockingHttpParams() {
        }

        public NonBlockingHttpParams(HttpParams defaults) {
            super(defaults);
        }

        public Object getParameter(String name) {
            HttpParams defaults;
            Object param = null;
            this.paramLock.readLock().lock();
            try {
                param = this.parameters.get(name);
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            if (param == null && (defaults = this.getDefaults()) != null) {
                param = defaults.getParameter(name);
            }
            return param;
        }

        public void setParameter(String name, Object value) {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.put(name, value);
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        public boolean isParameterSetLocally(String name) {
            this.paramLock.readLock().lock();
            try {
                boolean bl = this.parameters.get(name) != null;
                return bl;
            }
            finally {
                this.paramLock.readLock().unlock();
            }
        }

        public void clear() {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.clear();
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        public Object clone() throws CloneNotSupportedException {
            NonBlockingHttpParams clone = (NonBlockingHttpParams)((Object)super.clone());
            this.paramLock.readLock().lock();
            try {
                clone.parameters = (HashMap)this.parameters.clone();
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            clone.setDefaults(this.getDefaults());
            return clone;
        }
    }

    static class SecureHttpMethodResponse
    extends HttpMethodResponse {
        protected HostConfiguration hostConfig;
        protected EncryptionUtils encryptionUtils;
        protected byte[] decryptedBody;

        public SecureHttpMethodResponse(HttpMethod method, HostConfiguration hostConfig, EncryptionUtils encryptionUtils) throws AuthenticationException, IOException {
            super(method);
            this.hostConfig = hostConfig;
            this.encryptionUtils = encryptionUtils;
            if (method.getStatusCode() == 200) {
                this.decryptedBody = encryptionUtils.decryptResponseBody(method);
                if (!this.authenticate()) {
                    throw new AuthenticationException(method);
                }
            }
        }

        protected boolean authenticate() throws IOException {
            return this.encryptionUtils.authenticateResponse(this.method, this.hostConfig.getHost(), this.decryptedBody);
        }

        @Override
        public InputStream getContentAsStream() throws IOException {
            if (this.decryptedBody != null) {
                return new ByteArrayInputStream(this.decryptedBody);
            }
            return null;
        }
    }
}

