/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.error;

public class ExceptionStackUtil {
    private static final String JAVASCRIPT_EXCEPTION = "org.mozilla.javascript.JavaScriptException";
    private static final String EXCEPTION_DELIMITER = ":";

    public static Throwable getCause(Throwable throwable, Class<?> ... possibleCauses) {
        while (throwable != null) {
            Class<?> throwableClass = throwable.getClass();
            boolean isJavaScriptException = throwableClass.getName().contains(JAVASCRIPT_EXCEPTION);
            String throwableMsg = throwable.getMessage() != null ? throwable.getMessage() : "";
            for (Class<?> possibleCauseClass : possibleCauses) {
                String possibleCauseClassName = possibleCauseClass.getName();
                if (!possibleCauseClass.isAssignableFrom(throwableClass) && (!isJavaScriptException || !throwableMsg.contains(possibleCauseClassName + EXCEPTION_DELIMITER))) continue;
                return throwable;
            }
            Throwable cause = throwable.getCause();
            throwable = throwable == cause ? null : cause;
        }
        return null;
    }
}

