/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.util.Random;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;

public class ProbabilitySampler
implements Sampler<Object> {
    private static final Log LOG = LogFactory.getLog(ProbabilitySampler.class);
    public final double threshold;
    private Random random = new Random();
    public static final String SAMPLER_FRACTION_CONF_KEY = "sampler.fraction";

    public ProbabilitySampler(HTraceConfiguration conf) {
        this.threshold = Double.parseDouble(conf.get(SAMPLER_FRACTION_CONF_KEY));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created new ProbabilitySampler with threshold = " + this.threshold + ".");
        }
    }

    @Override
    public boolean next(Object info) {
        return this.random.nextDouble() < this.threshold;
    }
}

