/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public final class CloseableUtils {
    private CloseableUtils() {
    }

    public static void close(Closeable conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            CloseableUtils.close(c);
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection ... connections) {
        for (Connection c : connections) {
            CloseableUtils.close(c);
        }
    }

    public static void close(Statement conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement ... statements) {
        for (Statement s : statements) {
            CloseableUtils.close(s);
        }
    }

    public static void close(Socket ... sockets) {
        for (Socket s : sockets) {
            try {
                if (s == null || s.isClosed()) continue;
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

