/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.Tracker;

public class TrackerRegistry {
    private Map<String, ConcurrentHashMap<Class<? extends Tracker>, Tracker>> trackers = new ConcurrentHashMap<String, ConcurrentHashMap<Class<? extends Tracker>, Tracker>>();
    private volatile ModelTracker modelTracker;

    public Set<String> getCoreNames() {
        return this.trackers.keySet();
    }

    public Collection<Tracker> getTrackersForCore(String coreName) {
        ConcurrentHashMap<Class<? extends Tracker>, Tracker> coreTrackers = this.trackers.get(coreName);
        return coreTrackers == null ? Collections.emptyList() : coreTrackers.values();
    }

    public boolean hasTrackersForCore(String coreName) {
        return this.trackers.containsKey(coreName);
    }

    public <T extends Tracker> T getTrackerForCore(String coreName, Class<T> trackerClass) {
        Map coreTrackers = this.trackers.get(coreName);
        return (T)(null == coreTrackers ? null : (Tracker)coreTrackers.get(trackerClass));
    }

    public synchronized void register(String coreName, Tracker tracker) {
        ConcurrentHashMap<Class<Tracker>, Tracker> coreTrackers = this.trackers.get(coreName);
        if (coreTrackers == null) {
            coreTrackers = new ConcurrentHashMap();
            this.trackers.put(coreName, coreTrackers);
        }
        coreTrackers.put(tracker.getClass(), tracker);
    }

    public boolean removeTrackersForCore(String coreName) {
        return this.trackers.remove(coreName) != null;
    }

    public ModelTracker getModelTracker() {
        return this.modelTracker;
    }

    public void setModelTracker(ModelTracker modelTracker) {
        this.modelTracker = modelTracker;
    }
}

