/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.query.CachingTermPositions;
import org.alfresco.solr.query.SelfAxisStructuredFieldPosition;
import org.alfresco.solr.query.SolrContainerScorer;
import org.alfresco.solr.query.SolrPathQuery;
import org.alfresco.solr.query.StructuredFieldPosition;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class SolrPathScorer
extends Scorer {
    Scorer scorer;

    SolrPathScorer(Weight weight, Scorer scorer) {
        super(weight);
        this.scorer = scorer;
    }

    public static SolrPathScorer createPathScorer(SolrPathQuery solrPathQuery, LeafReaderContext context, Weight weight, DictionaryService dictionarySertvice, boolean repeat) throws IOException {
        if (solrPathQuery.getPathStructuredFieldPositions().size() == 0) {
            ArrayList answer = new ArrayList(2);
            answer.add(new SelfAxisStructuredFieldPosition());
            answer.add(new SelfAxisStructuredFieldPosition());
            solrPathQuery.appendQuery(answer);
        }
        for (StructuredFieldPosition sfp : solrPathQuery.getPathStructuredFieldPositions()) {
            if (sfp.getTermText() == null) continue;
            PostingsEnum p = context.reader().postings(new Term(solrPathQuery.getPathField(), sfp.getTermText()), 24);
            if (p == null) {
                return null;
            }
            CachingTermPositions ctp = new CachingTermPositions(p);
            sfp.setCachingTermPositions(ctp);
        }
        SolrContainerScorer cs = null;
        PostingsEnum rootContainerPositions = null;
        if (solrPathQuery.getPathRootTerm() != null) {
            rootContainerPositions = context.reader().postings(solrPathQuery.getPathRootTerm(), 24);
        }
        if (solrPathQuery.getPathStructuredFieldPositions().size() > 0) {
            cs = new SolrContainerScorer(weight, rootContainerPositions, solrPathQuery.getPathStructuredFieldPositions().toArray(new StructuredFieldPosition[0]));
        }
        return new SolrPathScorer(weight, cs);
    }

    public float score() throws IOException {
        return this.scorer.score();
    }

    public int freq() throws IOException {
        return this.scorer.freq();
    }

    public int docID() {
        return this.scorer.docID();
    }

    public DocIdSetIterator iterator() {
        return this.scorer.iterator();
    }
}

