/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrCachingPathWeight;
import org.alfresco.solr.query.SolrPathQuery;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.WrappedQuery;

public class SolrCachingPathScorer
extends AbstractSolrCachingScorer {
    SolrCachingPathScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrCachingPathScorer create(SolrCachingPathWeight weight, LeafReaderContext context, SolrIndexSearcher searcher, SolrPathQuery wrappedPathQuery) throws IOException {
        DocSet results = (DocSet)searcher.cacheLookup("alfrescoPathCache", (Object)wrappedPathQuery);
        if (results == null) {
            WrappedQuery wrapped = new WrappedQuery((Query)wrappedPathQuery);
            wrapped.setCache(false);
            results = searcher.getDocSet((Query)wrapped);
            searcher.cacheInsert("alfrescoPathCache", (Object)wrappedPathQuery, (Object)results);
        }
        return new SolrCachingPathScorer(weight, results, context, searcher);
    }
}

