/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.alfresco.solr.ContextAwareQuery;
import org.alfresco.solr.query.AllAccessCollector;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;

public class PostFilterQuery
extends Query
implements PostFilter {
    private int cost;
    private final Query query;

    public PostFilterQuery(int cost, Query query) {
        this.cost = cost;
        if (query == null) {
            throw new IllegalStateException("query cannot be null");
        }
        this.query = query;
    }

    public int hashCode() {
        int result = this.cost;
        result = 31 * result + this.query.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostFilterQuery)) {
            return false;
        }
        PostFilterQuery that = (PostFilterQuery)((Object)o);
        return this.query.equals((Object)that.query);
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public boolean getCache() {
        return false;
    }

    public void setCache(boolean cache) {
    }

    public boolean getCacheSep() {
        return false;
    }

    public void setCacheSep(boolean cacheSep) {
    }

    public String toString(String s) {
        return s;
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        ArrayList<PostFilter> postFilters = new ArrayList<PostFilter>();
        this.getPostFilters(this.query, postFilters);
        Collections.sort(postFilters, new PostFilterComp());
        ArrayList<DelegatingCollector> delegatingCollectors = new ArrayList<DelegatingCollector>();
        for (PostFilter postFilter : postFilters) {
            DelegatingCollector delegatingCollector = postFilter.getFilterCollector(searcher);
            if (delegatingCollector instanceof AllAccessCollector) continue;
            delegatingCollectors.add(delegatingCollector);
        }
        if (delegatingCollectors.size() == 0) {
            return new AllAccessCollector();
        }
        if (delegatingCollectors.size() == 1) {
            return (DelegatingCollector)delegatingCollectors.get(0);
        }
        return new WrapperCollector(delegatingCollectors);
    }

    private void getPostFilters(Query q, List<PostFilter> postFilters) {
        if (q instanceof BooleanQuery) {
            BooleanQuery bq = (BooleanQuery)q;
            List clauses = bq.clauses();
            for (BooleanClause clause : clauses) {
                Query q1 = clause.getQuery();
                this.getPostFilters(q1, postFilters);
            }
        } else if (q instanceof ContextAwareQuery) {
            ContextAwareQuery cq = (ContextAwareQuery)q;
            this.getPostFilters(cq.getLuceneQuery(), postFilters);
        } else if (q instanceof PostFilter) {
            postFilters.add((PostFilter)q);
        } else if (q instanceof BoostQuery) {
            BoostQuery bq = (BoostQuery)q;
            this.getPostFilters(bq.getQuery(), postFilters);
        }
    }

    private class PostFilterComp
    implements Comparator<PostFilter> {
        private PostFilterComp() {
        }

        @Override
        public int compare(PostFilter a, PostFilter b) {
            int costb;
            int costa = a.getCost();
            if (costa == (costb = b.getCost())) {
                return 0;
            }
            if (costa < costb) {
                return -1;
            }
            return 1;
        }
    }

    private static class WrapperCollector
    extends DelegatingCollector {
        private DelegatingCollector innerDelegate;
        private CollectorSink sink;

        public WrapperCollector(List<DelegatingCollector> delegatingCollectors) {
            for (DelegatingCollector delegatingCollector : delegatingCollectors) {
                if (this.innerDelegate == null) {
                    this.innerDelegate = delegatingCollector;
                    continue;
                }
                this.innerDelegate.setLastDelegate((Collector)delegatingCollector);
            }
            this.sink = new CollectorSink();
            this.innerDelegate.setLastDelegate((Collector)this.sink);
        }

        public void setScorer(Scorer scorer) throws IOException {
            super.setScorer(scorer);
            this.innerDelegate.setScorer(scorer);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.innerDelegate.getLeafCollector(context);
        }

        public void collect(int doc) throws IOException {
            this.innerDelegate.collect(doc);
            if (this.sink.doc == doc) {
                this.sink.doc = -1;
                super.collect(doc);
            }
        }
    }

    private static class CollectorSink
    extends DelegatingCollector {
        public int doc = -1;

        private CollectorSink() {
        }

        public void collect(int doc) throws IOException {
            this.doc = doc;
        }

        public void doSetNextReader(LeafReaderContext context) {
        }
    }
}

