/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.solr.query.MimetypeGroupingAnalyticsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.internal.csv.CSVParser;
import org.apache.solr.internal.csv.CSVStrategy;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimetypeGroupingQParserPlugin
extends QParserPlugin {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MimetypeGroupingQParserPlugin.class);
    private static HashMap<String, String> mappings = new HashMap();
    private static HashMap<String, ArrayList<String>> reverseMappings = new HashMap();
    private NamedList<Object> args;

    public static synchronized HashMap<String, ArrayList<String>> getReverseMappings() {
        return reverseMappings;
    }

    private static synchronized void initMap(String mappingFile) {
        String solrHome = SolrResourceLoader.locateSolrHome().toString();
        File file = new File(solrHome, mappingFile);
        try {
            CSVParser parser = new CSVParser((Reader)new FileReader(file), CSVStrategy.DEFAULT_STRATEGY);
            parser.getLine();
            while (true) {
                String[] vals = null;
                vals = parser.getLine();
                if (vals != null) {
                    mappings.put(vals[1], vals[2]);
                    ArrayList<String> grouped = reverseMappings.get(vals[2]);
                    if (grouped == null) {
                        grouped = new ArrayList();
                        reverseMappings.put(vals[2], grouped);
                    }
                    if (grouped.contains(vals[1])) continue;
                    grouped.add(vals[1]);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception during the MimetypeGroupingQParserPlugin. See the stacktrace below for further details.", (Throwable)exception);
        }
    }

    public void init(NamedList args) {
        this.args = args;
        String mappingFile = (String)args.get("mapping");
        MimetypeGroupingQParserPlugin.initMap(mappingFile);
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new MimetypeGroupingQParser(qstr, localParams, params, req, this.args, mappings);
    }

    public static class MimetypeGroupingQParser
    extends AbstractQParser {
        private HashMap<String, String> mappings;
        private boolean group = true;

        public MimetypeGroupingQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args, HashMap<String, String> mappings) {
            super(qstr, localParams, params, req, args);
            Boolean doGroup = localParams.getBool("group");
            if (doGroup != null) {
                this.group = doGroup;
            }
            this.mappings = mappings;
        }

        public Query parse() throws SyntaxError {
            return new MimetypeGroupingAnalyticsQuery(this.mappings, this.group);
        }
    }
}

