/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class FingerPrintComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "fingerprint";

    public void prepare(ResponseBuilder responseBuilder) {
    }

    public void process(ResponseBuilder responseBuilder) throws IOException {
        LegacyNumericRangeQuery q;
        if (!responseBuilder.req.getParams().getBool(COMPONENT_NAME, false)) {
            return;
        }
        String id = responseBuilder.req.getParams().get("id");
        NamedList response = responseBuilder.rsp.getValues();
        IndexSchema schema = responseBuilder.req.getSchema();
        SolrIndexSearcher searcher = responseBuilder.req.getSearcher();
        if (this.isNumber(id)) {
            long dbid = Long.parseLong(id);
            q = LegacyNumericRangeQuery.newLongRange((String)"DBID", (Long)dbid, (Long)(dbid + 1L), (boolean)true, (boolean)false);
        } else {
            Object query = id.startsWith("workspace") ? id : "workspace://SpacesStore/" + id;
            q = new TermQuery(new Term("LID", (String)query));
        }
        TopDocs docs = searcher.search((Query)q, 1);
        HashSet<String> fields = new HashSet<String>();
        fields.add("MINHASH");
        NamedList fingerPrint = new NamedList();
        ArrayList<Object> values = new ArrayList<Object>();
        if (docs.totalHits == 1) {
            IndexableField[] minHashes;
            ScoreDoc scoreDoc = docs.scoreDocs[0];
            Document doc = searcher.doc(scoreDoc.doc, fields);
            for (IndexableField minHash : minHashes = doc.getFields("MINHASH")) {
                SchemaField sf = schema.getFieldOrNull(minHash.name());
                Object value = DocsStreamer.getValue((SchemaField)sf, (IndexableField)minHash);
                values.add(value);
                fingerPrint.add("MINHASH", values);
            }
        }
        response.add(COMPONENT_NAME, (Object)fingerPrint);
    }

    private boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        return null;
    }
}

