/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Comparator;

public class DualPivotQuickSort {
    public static final int INSERTION_SORT_THRESHOLD = 17;
    public static final int DIST_SIZE = 13;

    public static <T> void sort(T[] elements, Comparator<T> comparator) {
        DualPivotQuickSort.sort(elements, 0, elements.length - 1, comparator);
    }

    public static <T> void sort(T[] elements, int left, int right, Comparator<T> comparator) {
        int length = right - left + 1;
        if (length < 17) {
            DualPivotQuickSort.insertionSort(elements, left, right, comparator);
        } else {
            DualPivotQuickSort.quickSort(elements, left, right, comparator);
        }
    }

    private static <T> void quickSort(T[] elements, int left, int right, Comparator<T> comparator) {
        int k;
        T pivot2;
        T pivot1;
        T x;
        int length = right - left;
        int sixth = length / 6;
        int m1 = left + sixth;
        int m2 = m1 + sixth;
        int m3 = m2 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (comparator.compare(elements[m1], elements[m2]) > 0) {
            x = elements[m1];
            elements[m1] = elements[m2];
            elements[m2] = x;
        }
        if (comparator.compare(elements[m4], elements[m5]) > 0) {
            x = elements[m4];
            elements[m4] = elements[m5];
            elements[m5] = x;
        }
        if (comparator.compare(elements[m1], elements[m3]) > 0) {
            x = elements[m1];
            elements[m1] = elements[m3];
            elements[m3] = x;
        }
        if (comparator.compare(elements[m2], elements[m3]) > 0) {
            x = elements[m2];
            elements[m2] = elements[m3];
            elements[m3] = x;
        }
        if (comparator.compare(elements[m1], elements[m4]) > 0) {
            x = elements[m1];
            elements[m1] = elements[m4];
            elements[m4] = x;
        }
        if (comparator.compare(elements[m3], elements[m4]) > 0) {
            x = elements[m3];
            elements[m3] = elements[m4];
            elements[m4] = x;
        }
        if (comparator.compare(elements[m2], elements[m5]) > 0) {
            x = elements[m2];
            elements[m2] = elements[m5];
            elements[m5] = x;
        }
        if (comparator.compare(elements[m2], elements[m3]) > 0) {
            x = elements[m2];
            elements[m2] = elements[m3];
            elements[m3] = x;
        }
        if (comparator.compare(elements[m4], elements[m5]) > 0) {
            x = elements[m4];
            elements[m4] = elements[m5];
            elements[m5] = x;
        }
        boolean diffPivots = comparator.compare(pivot1 = elements[m2], pivot2 = elements[m4]) != 0;
        elements[m2] = elements[left];
        elements[m4] = elements[right];
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = elements[k];
                if (comparator.compare(x, pivot1) < 0) {
                    elements[k] = elements[less];
                    elements[less++] = x;
                    continue;
                }
                if (comparator.compare(x, pivot2) <= 0) continue;
                while (comparator.compare(elements[great], pivot2) > 0 && k < great) {
                    --great;
                }
                elements[k] = elements[great];
                elements[great--] = x;
                x = elements[k];
                if (comparator.compare(x, pivot1) >= 0) continue;
                elements[k] = elements[less];
                elements[less++] = x;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = elements[k];
                if (comparator.compare(x, pivot1) == 0) continue;
                if (comparator.compare(x, pivot1) < 0) {
                    elements[k] = elements[less];
                    elements[less++] = x;
                    continue;
                }
                while (comparator.compare(elements[great], pivot2) > 0 && k < great) {
                    --great;
                }
                elements[k] = elements[great];
                elements[great--] = x;
                x = elements[k];
                if (comparator.compare(x, pivot1) >= 0) continue;
                elements[k] = elements[less];
                elements[less++] = x;
            }
        }
        elements[left] = elements[less - 1];
        elements[less - 1] = pivot1;
        elements[right] = elements[great + 1];
        elements[great + 1] = pivot2;
        DualPivotQuickSort.sort(elements, left, less - 2, comparator);
        DualPivotQuickSort.sort(elements, great + 2, right, comparator);
        if (great - less > length - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = elements[k];
                if (comparator.compare(x, pivot1) == 0) {
                    elements[k] = elements[less];
                    elements[less++] = x;
                    continue;
                }
                if (comparator.compare(x, pivot2) != 0) continue;
                elements[k] = elements[great];
                elements[great--] = x;
                x = elements[k];
                if (x != pivot1) continue;
                elements[k] = elements[less];
                elements[less++] = x;
            }
        }
        if (diffPivots) {
            DualPivotQuickSort.sort(elements, less, great, comparator);
        }
    }

    private static <T> void insertionSort(T[] elements, int left, int right, Comparator<T> comparator) {
        for (int i = left + 1; i <= right; ++i) {
            for (int j = i; j > left; --j) {
                if (comparator.compare(elements[j], elements[j - 1]) >= 0) continue;
                T x = elements[j - 1];
                elements[j - 1] = elements[j];
                elements[j] = x;
            }
        }
    }
}

