/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.util.Collection;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cloud {
    public static final String RESPONSE_SOLR_DOCUMENT_LIST = "responseSolrDocumentList";
    public static final String PARAM_GET_SOLR_DOCUMENT_LIST = "alfresco.getSolrDocumentList";
    protected static final Logger log = LoggerFactory.getLogger(Cloud.class);

    String getQuery(String fieldName, String operator, Collection ... valueLists) {
        StringBuilder query = new StringBuilder();
        for (Collection values : valueLists) {
            for (Object value : values) {
                query.append(fieldName).append(":").append("\"").append(value.toString()).append("\"").append(operator);
            }
        }
        if (query.length() >= operator.length()) {
            query.delete(query.length() - operator.length(), query.length());
        }
        return query.toString();
    }

    boolean exists(SolrRequestHandler requestHandler, SolrQueryRequest request, String query) {
        ModifiableSolrParams params = new ModifiableSolrParams(request.getParams());
        params.set("q", new String[]{query}).set("fl", new String[]{"id"}).set("rows", new String[]{"1"});
        ResultContext rc = this.getResultContext(requestHandler, request, (SolrParams)params);
        if (rc != null && rc.getDocList() != null) {
            return rc.getDocList().iterator().hasNext();
        }
        return false;
    }

    DocList getDocList(SolrRequestHandler requestHandler, SolrQueryRequest request, String query) {
        ModifiableSolrParams params = new ModifiableSolrParams(request.getParams());
        params.set("q", new String[]{query}).set("fl", new String[]{"id"}).set("rows", Integer.MAX_VALUE);
        ResultContext rc = this.getResultContext(requestHandler, request, (SolrParams)params);
        return rc != null ? rc.getDocList() : null;
    }

    ResultContext getResultContext(SolrRequestHandler requestHandler, SolrQueryRequest request, SolrParams params) {
        SolrQueryResponse solrRsp = this.getResponse(requestHandler, request, params);
        ResultContext rc = (ResultContext)solrRsp.getValues().get("response");
        return rc;
    }

    SolrDocumentList getSolrDocumentList(SolrRequestHandler requestHandler, SolrQueryRequest request, ModifiableSolrParams params) {
        params.set(PARAM_GET_SOLR_DOCUMENT_LIST, true);
        SolrQueryResponse solrRsp = this.getResponse(requestHandler, request, (SolrParams)params);
        SolrDocumentList docs = (SolrDocumentList)solrRsp.getValues().get(RESPONSE_SOLR_DOCUMENT_LIST);
        return docs;
    }

    SolrQueryResponse getResponse(SolrRequestHandler requestHandler, SolrQueryRequest request, SolrParams params) {
        request.setParams(params);
        log.info("Running query " + params.get("q"));
        SolrQueryResponse solrRsp = new SolrQueryResponse();
        requestHandler.handleRequest(request, solrRsp);
        return solrRsp;
    }
}

