/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.cache;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.cache.AsynchronouslyRefreshedCache;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.RefreshableCacheEvent;
import org.alfresco.util.cache.RefreshableCacheListener;
import org.alfresco.util.cache.RefreshableCacheRefreshEvent;
import org.alfresco.util.cache.RefreshableCacheRefreshedEvent;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionSupportUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractAsynchronouslyRefreshedCache<T>
implements AsynchronouslyRefreshedCache<T>,
RefreshableCacheListener,
Callable<Void>,
BeanNameAware,
InitializingBean,
TransactionListener {
    private static final String RESOURCE_KEY_TXN_DATA = "AbstractAsynchronouslyRefreshedCache.TxnData";
    private static Log logger = LogFactory.getLog(AbstractAsynchronouslyRefreshedCache.class);
    private ThreadPoolExecutor threadPoolExecutor;
    private AsynchronouslyRefreshedCacheRegistry registry;
    private List<RefreshableCacheListener> listeners = new LinkedList<RefreshableCacheListener>();
    protected final ReentrantReadWriteLock liveLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock refreshLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock runLock = new ReentrantReadWriteLock();
    protected HashMap<String, T> live = new HashMap();
    private LinkedHashSet<Refresh> refreshQueue = new LinkedHashSet();
    private String cacheId;
    private RefreshState refreshState = RefreshState.IDLE;
    private String resourceKeyTxnData;

    @Override
    public void register(RefreshableCacheListener listener) {
        this.listeners.add(listener);
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setRegistry(AsynchronouslyRefreshedCacheRegistry registry) {
        this.registry = registry;
    }

    public void init() {
        this.registry.register(this);
    }

    public String toString() {
        return "AbstractAsynchronouslyRefreshedCache [cacheId=" + this.cacheId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(String key) {
        this.liveLock.readLock().lock();
        try {
            if (this.live.get(key) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("get() from cache for key " + key + " on " + this));
                }
                T t = this.live.get(key);
                return t;
            }
        }
        finally {
            this.liveLock.readLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get() miss, scheduling and waiting for key " + key + " on " + this));
        }
        Refresh refresh = null;
        this.refreshLock.writeLock().lock();
        try {
            for (Refresh existing : this.refreshQueue) {
                if (!existing.getKey().equals(key)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("get() found existing build to wait for on " + this));
                }
                refresh = existing;
            }
            if (refresh == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("get() building from scratch on " + this));
                }
                refresh = new Refresh(key);
                this.refreshQueue.add(refresh);
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
        this.submit();
        this.waitForBuild(refresh);
        return this.get(key);
    }

    public void forceInChangesForThisUncommittedTransaction(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for tenant " + key + " on " + this));
        }
        T cache = this.buildCache(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache built for tenant " + key + " on " + this));
        }
        this.liveLock.writeLock().lock();
        try {
            this.live.put(key, cache);
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
        this.broadcastEvent(new RefreshableCacheRefreshedEvent(this.cacheId, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForBuild(Refresh refresh) {
        while (refresh.getState() != RefreshState.DONE) {
            Refresh refresh2 = refresh;
            synchronized (refresh2) {
                try {
                    refresh.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void refresh(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async cache refresh request for tenant " + key + " on " + this));
        }
        this.registry.broadcastEvent(new RefreshableCacheRefreshEvent(this.cacheId, key), true);
    }

    @Override
    public void onRefreshableCacheEvent(RefreshableCacheEvent refreshableCacheEvent) {
        if (!refreshableCacheEvent.getCacheId().equals(this.cacheId)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Async cache onRefreshableCacheEvent " + refreshableCacheEvent + " on " + this));
        }
        if (TransactionSupportUtil.getTransactionId() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Async cache adding" + refreshableCacheEvent.getKey() + " to post commit list: " + this));
            }
            TransactionData txData = this.getTransactionData();
            txData.keys.add(refreshableCacheEvent.getKey());
        } else {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            keys.add(refreshableCacheEvent.getKey());
            this.queueRefreshAndSubmit(keys);
        }
    }

    private TransactionData getTransactionData() {
        TransactionData data = (TransactionData)TransactionSupportUtil.getResource(this.resourceKeyTxnData);
        if (data == null) {
            data = new TransactionData();
            data.keys = new LinkedHashSet();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSupportUtil.bindListener(this, 0);
            }
            TransactionSupportUtil.bindResource(this.resourceKeyTxnData, data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRefreshAndSubmit(LinkedHashSet<String> tenantIds) {
        if (tenantIds == null || tenantIds.size() == 0) {
            return;
        }
        this.refreshLock.writeLock().lock();
        try {
            for (String tenantId : tenantIds) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Async cache adding refresh to queue for tenant " + tenantId + " on " + this));
                }
                this.refreshQueue.add(new Refresh(tenantId));
            }
        }
        finally {
            this.refreshLock.writeLock().unlock();
        }
        this.submit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(String key) {
        this.refreshLock.readLock().lock();
        try {
            for (Refresh refresh : this.refreshQueue) {
                if (!refresh.getKey().equals(key)) continue;
                boolean bl = false;
                return bl;
            }
            if (TransactionSupportUtil.getTransactionId() != null) {
                boolean bl = !this.getTransactionData().keys.contains(key);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.refreshLock.readLock().unlock();
        }
    }

    private Refresh getNextRefresh() {
        if (this.runLock.writeLock().isHeldByCurrentThread()) {
            for (Refresh refresh : this.refreshQueue) {
                if (refresh.state != RefreshState.WAITING) continue;
                return refresh;
            }
            return null;
        }
        throw new IllegalStateException("Method should not be called without holding the write lock: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countWaiting() {
        int count = 0;
        if (this.runLock.writeLock().isHeldByCurrentThread()) {
            this.refreshLock.readLock().lock();
            try {
                for (Refresh refresh : this.refreshQueue) {
                    if (refresh.state != RefreshState.WAITING) continue;
                    ++count;
                }
                int n = count;
                return n;
            }
            finally {
                this.refreshLock.readLock().unlock();
            }
        }
        throw new IllegalStateException("Method should not be called without holding the write lock: " + this);
    }

    private void submit() {
        this.runLock.writeLock().lock();
        try {
            if (this.refreshState == RefreshState.IDLE) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("submit() scheduling job: " + this));
                }
                this.threadPoolExecutor.submit(this);
                this.refreshState = RefreshState.WAITING;
            }
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    @Override
    public Void call() {
        this.liveLock.writeLock().lock();
        try {
            this.doCall();
            Void void_ = null;
            return void_;
        }
        catch (Exception e) {
            logger.error((Object)("Cache update failed: " + this), (Throwable)e);
            this.runLock.writeLock().lock();
            try {
                this.threadPoolExecutor.submit(this);
                this.refreshState = RefreshState.WAITING;
            }
            finally {
                this.runLock.writeLock().unlock();
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
    }

    private void doCall() throws Exception {
        Refresh refresh = this.setUpRefresh();
        if (refresh == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for key" + refresh.getKey() + " on " + this));
        }
        try {
            this.doRefresh(refresh);
        }
        catch (Exception e) {
            refresh.setState(RefreshState.WAITING);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(Refresh refresh) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building cache for tenant" + refresh.getKey() + ": " + this));
        }
        T cache = this.buildCache(refresh.getKey());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(".... cache built for tenant" + refresh.getKey()));
        }
        this.liveLock.writeLock().lock();
        try {
            this.live.put(refresh.getKey(), cache);
        }
        finally {
            this.liveLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache entry updated for tenant" + refresh.getKey()));
        }
        this.broadcastEvent(new RefreshableCacheRefreshedEvent(this.cacheId, refresh.key));
        this.runLock.writeLock().lock();
        try {
            this.refreshLock.writeLock().lock();
            try {
                if (this.countWaiting() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Rescheduling more work: " + this));
                    }
                    this.threadPoolExecutor.submit(this);
                    this.refreshState = RefreshState.WAITING;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Nothing to do; going idle: " + this));
                    }
                    this.refreshState = RefreshState.IDLE;
                }
                refresh.setState(RefreshState.DONE);
                this.refreshQueue.remove(refresh);
            }
            finally {
                this.refreshLock.writeLock().unlock();
            }
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    private Refresh setUpRefresh() throws Exception {
        Refresh refresh = null;
        this.runLock.writeLock().lock();
        try {
            if (this.refreshState == RefreshState.WAITING) {
                this.refreshLock.writeLock().lock();
                try {
                    refresh = this.getNextRefresh();
                    if (refresh != null) {
                        this.refreshState = RefreshState.RUNNING;
                        refresh.setState(RefreshState.RUNNING);
                        Refresh refresh2 = refresh;
                        return refresh2;
                    }
                    this.refreshState = RefreshState.IDLE;
                    Refresh refresh3 = null;
                    return refresh3;
                }
                finally {
                    this.refreshLock.writeLock().unlock();
                }
            }
            Refresh refresh4 = null;
            return refresh4;
        }
        catch (Exception e) {
            if (refresh != null) {
                refresh.setState(RefreshState.WAITING);
            }
            throw e;
        }
        finally {
            this.runLock.writeLock().unlock();
        }
    }

    public void setBeanName(String name) {
        this.cacheId = name;
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    protected abstract T buildCache(String var1);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory(this, "threadPoolExecutor", this.threadPoolExecutor);
        PropertyCheck.mandatory(this, "registry", this.registry);
        this.registry.register(this);
        this.resourceKeyTxnData = "AbstractAsynchronouslyRefreshedCache.TxnData." + this.cacheId;
    }

    public void broadcastEvent(RefreshableCacheEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying cache listeners for " + this.getCacheId() + " " + event));
        }
        for (RefreshableCacheListener listener : this.listeners) {
            listener.onRefreshableCacheEvent(event);
        }
    }

    @Override
    public void beforeCommit(boolean readOnly) {
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
        TransactionData txnData = this.getTransactionData();
        this.queueRefreshAndSubmit(txnData.keys);
    }

    @Override
    public void afterRollback() {
    }

    private static enum RefreshState {
        IDLE,
        WAITING,
        RUNNING,
        DONE;

    }

    private static class Refresh {
        private String key;
        private volatile RefreshState state = RefreshState.WAITING;

        Refresh(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public RefreshState getState() {
            return this.state;
        }

        public void setState(RefreshState state) {
            this.state = state;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Refresh other = (Refresh)obj;
            if (this.state != other.state) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return "Refresh [key=" + this.key + ", state=" + this.state + ", hashCode()=" + this.hashCode() + "]";
        }
    }

    private static class TransactionData {
        LinkedHashSet<String> keys;

        private TransactionData() {
        }
    }
}

