/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public class RequestHeadersHttpClient
extends HttpClient {
    private Map<String, String> defaultHeaders;

    public RequestHeadersHttpClient(MultiThreadedHttpConnectionManager connectionManager) {
        super((HttpConnectionManager)connectionManager);
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    private void addDefaultHeaders(HttpMethod method) {
        if (this.defaultHeaders != null) {
            this.defaultHeaders.forEach((k, v) -> {
                boolean add;
                Header h = method.getRequestHeader(k);
                boolean bl = add = h == null || h.getValue() == null || !h.getValue().equals(v);
                if (add) {
                    method.addRequestHeader(k, v);
                }
            });
        }
    }

    public int executeMethod(HttpMethod method) throws IOException, HttpException {
        this.addDefaultHeaders(method);
        return super.executeMethod(method);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod method) throws IOException, HttpException {
        this.addDefaultHeaders(method);
        return super.executeMethod(hostConfiguration, method);
    }

    public int executeMethod(HostConfiguration hostconfig, HttpMethod method, HttpState state) throws IOException, HttpException {
        this.addDefaultHeaders(method);
        return super.executeMethod(hostconfig, method, state);
    }
}

