/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class NameChecker
implements InitializingBean {
    private DictionaryService dictionaryService;
    private Constraint nameConstraint;
    private String namespaceURI = "http://www.alfresco.org/model/content/1.0";
    private String constraintLocalName = "filename";

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setConstraintLocalName(String constraintLocalName) {
        this.constraintLocalName = constraintLocalName;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        QName qNameConstraint = QName.createQName(this.namespaceURI, this.constraintLocalName);
        ConstraintDefinition constraintDef = this.dictionaryService.getConstraint(qNameConstraint);
        if (constraintDef == null) {
            throw new AlfrescoRuntimeException("Constraint definition does not exist: " + qNameConstraint);
        }
        this.nameConstraint = constraintDef.getConstraint();
        if (this.nameConstraint == null) {
            throw new AlfrescoRuntimeException("Constraint does not exist: " + qNameConstraint);
        }
    }

    public void evaluate(Object value) {
        this.nameConstraint.evaluate(value);
    }
}

