/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uk;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import morfologik.stemming.Dictionary;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.morfologik.MorfologikFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;

public final class UkrainianMorfologikAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public UkrainianMorfologikAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public UkrainianMorfologikAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public UkrainianMorfologikAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stemExclusionSet));
    }

    protected Reader initReader(String fieldName, Reader reader) {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        builder.add("\u2019", "'");
        builder.add("\u2018", "'");
        builder.add("\u02bc", "'");
        builder.add("`", "'");
        builder.add("\u00b4", "'");
        builder.add("\u0301", "");
        builder.add("\u00ad", "");
        NormalizeCharMap normMap = builder.build();
        reader = new MappingCharFilter(normMap, reader);
        return reader;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        Object result = new StandardFilter((TokenStream)source);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter((TokenStream)result, this.stemExclusionSet);
        }
        result = new MorfologikFilter((TokenStream)result, UkrainianMorfologikAnalyzer.getDictionary());
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    private static Dictionary getDictionary() {
        try {
            return Dictionary.read((URL)UkrainianMorfologikAnalyzer.class.getClassLoader().getResource("ua/net/nlp/ukrainian.dict"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet((Reader)IOUtils.getDecodingReader(UkrainianMorfologikAnalyzer.class, (String)UkrainianMorfologikAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

