/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.rule;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.cloud.rule.RemoteCallback;
import org.apache.solr.common.cloud.rule.SnitchContext;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSnitchContext
extends SnitchContext {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final CoreContainer coreContainer;

    public ServerSnitchContext(SnitchContext.SnitchInfo perSnitch, String node, Map<String, Object> session, CoreContainer coreContainer) {
        super(perSnitch, node, session);
        this.coreContainer = coreContainer;
    }

    public Map getZkJson(String path) {
        if (this.coreContainer.isZooKeeperAware()) {
            try {
                byte[] data = this.coreContainer.getZkController().getZkClient().getData(path, null, new Stat(), true);
                if (data == null) {
                    return null;
                }
                return (Map)Utils.fromJSON((byte[])data);
            }
            catch (Exception e) {
                log.warn("Unable to read from ZK path : " + path, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void invokeRemote(String node, ModifiableSolrParams params, String klas, RemoteCallback callback) {
        if (callback == null) {
            callback = this;
        }
        String url = this.coreContainer.getZkController().getZkStateReader().getBaseUrlForNodeName(node);
        params.add("class", new String[]{klas});
        params.add("action", new String[]{CoreAdminParams.CoreAdminAction.INVOKE.toString()});
        try {
            SimpleSolrResponse rsp = this.invoke(this.coreContainer.getUpdateShardHandler(), url, "/admin/cores", (SolrParams)params);
            Map returnedVal = (Map)rsp.getResponse().get(klas);
            if (this.exception != null) {
                callback.remoteCallback((SnitchContext)this, returnedVal);
            }
            callback.remoteCallback((SnitchContext)this, returnedVal);
        }
        catch (Exception e) {
            log.error("Unable to invoke snitch counterpart", (Throwable)e);
            this.exception = e;
        }
    }

    public SimpleSolrResponse invoke(UpdateShardHandler shardHandler, String url, String path, SolrParams params) throws IOException, SolrServerException {
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, path, params);
        try (HttpSolrClient client = new HttpSolrClient.Builder(url).withHttpClient(shardHandler.getHttpClient()).withResponseParser((ResponseParser)new BinaryResponseParser()).build();){
            NamedList rsp;
            request.response.nl = rsp = client.request((SolrRequest)request);
            SimpleSolrResponse simpleSolrResponse = request.response;
            return simpleSolrResponse;
        }
    }
}

