/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public RestoreCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String restoreCollectionName = message.getStr("collection");
        String backupName = message.getStr("name");
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        String asyncId = message.getStr("async");
        String repo = message.getStr("repository");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        CoreContainer cc = this.ocmh.overseer.getZkController().getCoreContainer();
        BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
        URI location = repository.createURI(message.getStr("location"));
        URI backupPath = repository.resolve(location, backupName);
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        BackupManager backupMgr = new BackupManager(repository, zkStateReader);
        Properties properties = backupMgr.readBackupProperties(location, backupName);
        String backupCollection = properties.getProperty("collection");
        DocCollection backupCollectionState = backupMgr.readCollectionState(location, backupName, backupCollection);
        List<String> nodeList = OverseerCollectionMessageHandler.getLiveOrLiveAndCreateNodeSetList(zkStateReader.getClusterState().getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM);
        int numShards = backupCollectionState.getActiveSlices().size();
        int repFactor = message.getInt("replicationFactor", backupCollectionState.getReplicationFactor());
        int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(backupCollectionState.getMaxShardsPerNode()));
        int availableNodeCount = nodeList.size();
        if (numShards * repFactor > availableNodeCount * maxShardsPerNode) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Solr cloud with available number of nodes:%d is insufficient for restoring a collection with %d shards, replication factor %d and maxShardsPerNode %d. Consider increasing maxShardsPerNode value OR number of available nodes.", availableNodeCount, numShards, repFactor, maxShardsPerNode));
        }
        String configName = (String)properties.get("collection.configName");
        String restoreConfigName = message.getStr("collection.configName", configName);
        if (zkStateReader.getConfigManager().configExists(restoreConfigName).booleanValue()) {
            log.info("Using existing config {}", (Object)restoreConfigName);
        } else {
            log.info("Uploading config {}", (Object)restoreConfigName);
            backupMgr.uploadConfigDir(location, backupName, configName, restoreConfigName);
        }
        log.info("Starting restore into collection={} with backup_name={} at location={}", new Object[]{restoreCollectionName, backupName, location});
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.CREATE.toString());
        propMap.put("fromApi", "true");
        for (String string : OverseerCollectionMessageHandler.COLL_PROPS.keySet()) {
            Object object = message.getProperties().getOrDefault(string, backupCollectionState.get(string));
            if (object == null) continue;
            propMap.put(string, object);
        }
        propMap.put("name", restoreCollectionName);
        propMap.put("createNodeSet", "EMPTY");
        propMap.put("collection.configName", restoreConfigName);
        Map routerProps = (Map)backupCollectionState.getProperties().get("router");
        for (Map.Entry entry : routerProps.entrySet()) {
            propMap.put("router." + (String)entry.getKey(), entry.getValue());
        }
        Set set = backupCollectionState.getActiveSlicesMap().keySet();
        if (backupCollectionState.getRouter() instanceof ImplicitDocRouter) {
            propMap.put("shards", StrUtils.join(set, (char)','));
        } else {
            propMap.put("numShards", set.size());
            Collection collection = backupCollectionState.getActiveSlices();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>(collection.size());
            for (Slice backupSlice : collection) {
                newSlices.put(backupSlice.getName(), new Slice(backupSlice.getName(), Collections.emptyMap(), backupSlice.getProperties()));
            }
            propMap.put("shards", newSlices);
        }
        this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(zkStateReader.getClusterState(), new ZkNodeProps(propMap), new NamedList());
        DocCollection restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        DistributedQueue inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        for (Slice shard : restoreCollection.getSlices()) {
            hashMap.put(shard.getName(), Slice.State.CONSTRUCTION.toString());
        }
        hashMap.put("collection", restoreCollectionName);
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(hashMap)));
        ClusterState clusterState = zkStateReader.getClusterState();
        ArrayList<String> arrayList = new ArrayList<String>();
        restoreCollection.getSlices().forEach(x -> sliceNames2.add(x.getName()));
        Map<ReplicaAssigner.Position, String> positionVsNodes = this.ocmh.identifyNodes(clusterState, nodeList, message, arrayList, repFactor);
        for (Slice slice : restoreCollection.getSlices()) {
            log.debug("Adding replica for shard={} collection={} ", (Object)slice.getName(), (Object)restoreCollection);
            HashMap<String, Object> propMap3 = new HashMap<String, Object>();
            propMap3.put("operation", CollectionParams.CollectionAction.CREATESHARD);
            propMap3.put("collection", restoreCollectionName);
            propMap3.put("shard", slice.getName());
            for (Map.Entry<ReplicaAssigner.Position, String> pvn : positionVsNodes.entrySet()) {
                ReplicaAssigner.Position position = pvn.getKey();
                if (position.shard != slice.getName()) continue;
                String node = pvn.getValue();
                propMap3.put("node", node);
                positionVsNodes.remove(position);
                break;
            }
            if (asyncId != null) {
                propMap3.put("async", asyncId);
            }
            this.ocmh.addPropertyParams(message, propMap3);
            this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap3), new NamedList(), null);
        }
        restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        for (Slice slice : restoreCollection.getSlices()) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RESTORECORE.toString()});
            params.set("name", new String[]{"snapshot." + slice.getName()});
            params.set("location", new String[]{backupPath.toASCIIString()});
            params.set("repository", new String[]{repo});
            this.ocmh.sliceCmd(clusterState, params, null, slice, shardHandler, asyncId, requestMap);
        }
        this.ocmh.processResponses(new NamedList(), shardHandler, true, "Could not restore core", asyncId, requestMap);
        HashMap<String, String> propMap4 = new HashMap<String, String>();
        propMap4.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        propMap4.put("collection", restoreCollectionName);
        for (Slice shard : restoreCollection.getSlices()) {
            propMap4.put(shard.getName(), Slice.State.ACTIVE.toString());
        }
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(propMap4)));
        restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        Integer numReplicas = restoreCollection.getReplicationFactor();
        if (numReplicas != null && numReplicas > 1) {
            log.info("Adding replicas to restored collection={}", (Object)restoreCollection);
            for (Slice slice : restoreCollection.getSlices()) {
                for (int i = 1; i < numReplicas; ++i) {
                    log.debug("Adding replica for shard={} collection={} ", (Object)slice.getName(), (Object)restoreCollection);
                    HashMap<String, Object> propMap5 = new HashMap<String, Object>();
                    propMap5.put("collection", restoreCollectionName);
                    propMap5.put("shard", slice.getName());
                    for (Map.Entry<ReplicaAssigner.Position, String> pvn : positionVsNodes.entrySet()) {
                        ReplicaAssigner.Position position = pvn.getKey();
                        if (position.shard != slice.getName()) continue;
                        String node = pvn.getValue();
                        propMap5.put("node", node);
                        positionVsNodes.remove(position);
                        break;
                    }
                    if (asyncId != null) {
                        propMap5.put("async", asyncId);
                    }
                    this.ocmh.addPropertyParams(message, propMap5);
                    this.ocmh.addReplica(zkStateReader.getClusterState(), new ZkNodeProps(propMap5), results, null);
                }
            }
        }
        log.info("Completed restoring collection={} backupName={}", (Object)restoreCollection, (Object)backupName);
    }
}

